/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileManager {
    private List<File> directories = new ArrayList<File>();
    private boolean acceptInnerClasses = true;

    public void acceptInnerClasses(boolean b) {
        this.acceptInnerClasses = b;
    }

    public void addDirectory(String name) throws IOException {
        File directory = new File(name);
        if (!directory.isDirectory() && !this.acceptJarFile(directory)) {
            throw new IOException("Invalid directory or JAR file: " + name);
        }
        this.directories.add(directory);
    }

    public boolean acceptFile(File file) {
        return this.acceptClassFile(file) || this.acceptJarFile(file);
    }

    public boolean acceptClassFile(File file) {
        return file.isFile() && this.acceptClassFileName(file.getName());
    }

    public boolean acceptClassFileName(String name) {
        if (!this.acceptInnerClasses && name.toLowerCase().indexOf("$") > 0) {
            return false;
        }
        return name.toLowerCase().endsWith(".class");
    }

    public boolean acceptJarFile(File file) {
        return this.isJar(file) || this.isZip(file) || this.isWar(file);
    }

    public Collection<File> extractFiles() {
        TreeSet<File> files = new TreeSet<File>();
        for (File directory : this.directories) {
            this.collectFiles(directory, files);
        }
        return files;
    }

    private void collectFiles(File directory, Collection<File> files) {
        if (directory.isFile()) {
            this.addFile(directory, files);
        } else {
            String[] directoryFiles;
            for (String directoryFile : directoryFiles = directory.list()) {
                File file = new File(directory, directoryFile);
                if (this.acceptFile(file)) {
                    this.addFile(file, files);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.collectFiles(file, files);
            }
        }
    }

    private void addFile(File f, Collection<File> files) {
        if (!files.contains(f)) {
            files.add(f);
        }
    }

    private boolean isWar(File file) {
        return this.existsWithExtension(file, ".war");
    }

    private boolean isZip(File file) {
        return this.existsWithExtension(file, ".zip");
    }

    private boolean isJar(File file) {
        return this.existsWithExtension(file, ".jar");
    }

    private boolean existsWithExtension(File file, String extension) {
        return file.isFile() && file.getName().toLowerCase().endsWith(extension);
    }
}

