/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import jdepend.framework.ClassFileParser;
import jdepend.framework.DependencyConstraint;
import jdepend.framework.FileManager;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaClassBuilder;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageFilter;
import jdepend.framework.ParserListener;
import jdepend.framework.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDepend {
    private Map<String, JavaPackage> packages;
    private FileManager fileManager;
    private PackageFilter filter;
    private ClassFileParser parser;
    private JavaClassBuilder builder;
    private Collection<String> components;

    public JDepend() {
        this(PackageFilter.all().excludingProperties());
    }

    public JDepend(PackageFilter filter) {
        this.setFilter(filter);
        this.packages = new HashMap<String, JavaPackage>();
        this.fileManager = new FileManager();
        this.parser = new ClassFileParser(filter);
        this.builder = new JavaClassBuilder(this.parser, this.fileManager);
        PropertyConfigurator config = new PropertyConfigurator();
        this.addPackages(config.getConfiguredPackages());
        this.analyzeInnerClasses(config.getAnalyzeInnerClasses());
    }

    public Collection<JavaPackage> analyze() {
        Collection<JavaClass> classes = this.builder.build();
        for (JavaClass aClass : classes) {
            this.analyzeClass(aClass);
        }
        return this.getPackages();
    }

    public void addDirectory(String name) throws IOException {
        this.fileManager.addDirectory(name);
    }

    public void setComponents(String components) {
        this.components = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(components, ",");
        while (st.hasMoreTokens()) {
            String component = st.nextToken();
            this.components.add(component);
        }
    }

    public void analyzeInnerClasses(boolean b) {
        this.fileManager.acceptInnerClasses(b);
    }

    public Collection<JavaPackage> getPackages() {
        return this.packages.values();
    }

    public JavaPackage getPackage(String name) {
        return this.packages.get(name);
    }

    public int countPackages() {
        return this.getPackages().size();
    }

    public int countClasses() {
        return this.builder.countClasses();
    }

    public boolean containsCycles() {
        for (JavaPackage jPackage : this.getPackages()) {
            if (!jPackage.containsCycle()) continue;
            return true;
        }
        return false;
    }

    public boolean dependencyMatch(DependencyConstraint constraint) {
        return constraint.match(this.getPackages()).matches();
    }

    public DependencyConstraint.MatchResult analyzeDependencies(DependencyConstraint constraint) {
        return constraint.match(this.getPackages());
    }

    public void addParseListener(ParserListener listener) {
        this.parser.addParseListener(listener);
    }

    public JavaPackage addPackage(String name) {
        JavaPackage pkg = this.packages.get(name = this.toComponent(name));
        if (pkg == null) {
            pkg = new JavaPackage(name);
            this.addPackage(pkg);
        }
        return pkg;
    }

    private String toComponent(String packageName) {
        if (this.components != null) {
            for (String component : this.components) {
                if (!packageName.startsWith(component + ".")) continue;
                return component;
            }
        }
        return packageName;
    }

    public void addPackages(Collection<JavaPackage> packages) {
        for (JavaPackage pkg : packages) {
            this.addPackage(pkg);
        }
    }

    public void addPackage(JavaPackage pkg) {
        if (!this.packages.containsValue(pkg)) {
            this.packages.put(pkg.getName(), pkg);
        }
    }

    public PackageFilter getFilter() {
        if (this.filter == null) {
            this.filter = PackageFilter.all().excludingProperties();
        }
        return this.filter;
    }

    public void setFilter(PackageFilter filter) {
        if (this.parser != null) {
            this.parser.setFilter(filter);
        }
        this.filter = filter;
    }

    private void analyzeClass(JavaClass clazz) {
        String packageName = clazz.getPackageName();
        if (!this.getFilter().accept(packageName)) {
            return;
        }
        JavaPackage clazzPackage = this.addPackage(packageName);
        clazzPackage.addClass(clazz);
        for (JavaPackage importedPackage : clazz.getImportedPackages()) {
            importedPackage = this.addPackage(importedPackage.getName());
            clazzPackage.dependsUpon(importedPackage);
        }
    }
}

