/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import jdepend.framework.JavaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyConfigurator {
    private Properties properties;
    public static final String DEFAULT_PROPERTY_FILE = "jdepend.properties";

    public PropertyConfigurator() {
        this(PropertyConfigurator.getDefaultPropertyFile());
    }

    public PropertyConfigurator(Properties p) {
        this.properties = p;
    }

    public PropertyConfigurator(File f) {
        this(PropertyConfigurator.loadProperties(f));
    }

    public Collection<String> getFilteredPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("ignore")) continue;
            String path = this.properties.getProperty(key);
            StringTokenizer st = new StringTokenizer(path, ",");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                name = name.trim();
                packages.add(name);
            }
        }
        return packages;
    }

    public Collection<JavaPackage> getConfiguredPackages() {
        ArrayList<JavaPackage> packages = new ArrayList<JavaPackage>();
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("ignore") || key.equals("analyzeInnerClasses")) continue;
            String v = this.properties.getProperty(key);
            packages.add(new JavaPackage(key, Integer.parseInt(v)));
        }
        return packages;
    }

    public boolean getAnalyzeInnerClasses() {
        String key = "analyzeInnerClasses";
        if (this.properties.containsKey(key)) {
            String value = this.properties.getProperty(key);
            return Boolean.valueOf(value);
        }
        return true;
    }

    public static File getDefaultPropertyFile() {
        String home = System.getProperty("user.home");
        return new File(home, DEFAULT_PROPERTY_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) {
        InputStream is;
        Properties p = new Properties();
        try {
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            is = PropertyConfigurator.class.getResourceAsStream("/jdepend.properties");
        }
        try {
            if (is != null) {
                p.load(is);
            }
        }
        catch (IOException ignore) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ignore) {}
        }
        return p;
    }
}

