/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.http.impl.entity.EntityDeserializer;
import org.apache.http.impl.entity.EntitySerializer;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.io.HttpDataReceiver;
import org.apache.http.io.HttpDataTransmitter;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.message.BufferedHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.HeaderUtils;

public abstract class AbstractHttpClientConnection
implements HttpClientConnection {
    private final CharArrayBuffer buffer = new CharArrayBuffer(128);
    private final EntitySerializer entityserializer = this.createEntitySerializer();
    private final EntityDeserializer entitydeserializer = this.createEntityDeserializer();
    private final HttpResponseFactory responsefactory = this.createHttpResponseFactory();
    private HttpDataReceiver datareceiver = null;
    private HttpDataTransmitter datatransmitter = null;
    private int maxHeaderCount = -1;
    private int maxLineLen = -1;
    private int maxGarbageLines = -1;
    private HttpConnectionMetricsImpl metrics;

    protected abstract void assertOpen() throws IllegalStateException;

    protected EntityDeserializer createEntityDeserializer() {
        return new EntityDeserializer(new LaxContentLengthStrategy());
    }

    protected EntitySerializer createEntitySerializer() {
        return new EntitySerializer(new StrictContentLengthStrategy());
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return new DefaultHttpResponseFactory();
    }

    protected void init(HttpDataReceiver datareceiver, HttpDataTransmitter datatransmitter, HttpParams params) {
        if (datareceiver == null) {
            throw new IllegalArgumentException("HTTP data receiver may not be null");
        }
        if (datatransmitter == null) {
            throw new IllegalArgumentException("HTTP data transmitter may not be null");
        }
        this.datareceiver = datareceiver;
        this.datatransmitter = datatransmitter;
        this.maxHeaderCount = params.getIntParameter("http.connection.max-header-count", -1);
        this.maxLineLen = params.getIntParameter("http.connection.max-line-length", -1);
        this.maxGarbageLines = params.getIntParameter("http.connection.max-status-line-garbage", Integer.MAX_VALUE);
        this.metrics = new HttpConnectionMetricsImpl(datareceiver.getMetrics(), datatransmitter.getMetrics());
    }

    public boolean isResponseAvailable(int timeout) throws IOException {
        this.assertOpen();
        return this.datareceiver.isDataAvailable(timeout);
    }

    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        this.sendRequestLine(request);
        this.sendRequestHeaders(request);
        this.metrics.incrementRequestCount();
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        if (request.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.datatransmitter, request, request.getEntity());
    }

    protected void doFlush() throws IOException {
        this.datatransmitter.flush();
    }

    public void flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    protected void sendRequestLine(HttpRequest request) throws HttpException, IOException {
        this.buffer.clear();
        BasicRequestLine.format(this.buffer, request.getRequestLine());
        this.datatransmitter.writeLine(this.buffer);
    }

    protected void sendRequestHeaders(HttpRequest request) throws HttpException, IOException {
        Iterator it = request.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            if (header instanceof BufferedHeader) {
                this.datatransmitter.writeLine(((BufferedHeader)header).getBuffer());
                continue;
            }
            this.buffer.clear();
            BasicHeader.format(this.buffer, header);
            this.datatransmitter.writeLine(this.buffer);
        }
        this.buffer.clear();
        this.datatransmitter.writeLine(this.buffer);
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        this.assertOpen();
        HttpResponse response = this.readResponseStatusLine();
        this.readResponseHeaders(response);
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.metrics.incrementResponseCount();
        }
        return response;
    }

    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        this.assertOpen();
        HttpEntity entity = this.entitydeserializer.deserialize(this.datareceiver, response);
        response.setEntity(entity);
    }

    protected static boolean startsWithHTTP(CharArrayBuffer buffer) {
        try {
            int i = 0;
            while (HTTP.isWhitespace(buffer.charAt(i))) {
                ++i;
            }
            return buffer.charAt(i) == 'H' && buffer.charAt(i + 1) == 'T' && buffer.charAt(i + 2) == 'T' && buffer.charAt(i + 3) == 'P';
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    protected HttpResponse readResponseStatusLine() throws HttpException, IOException {
        this.buffer.clear();
        int count = 0;
        while (true) {
            int i;
            if ((i = this.datareceiver.readLine(this.buffer)) == -1 && count == 0) {
                throw new NoHttpResponseException("The target server failed to respond");
            }
            if (AbstractHttpClientConnection.startsWithHTTP(this.buffer)) break;
            if (i == -1 || count >= this.maxGarbageLines) {
                throw new ProtocolException("The server failed to respond with a valid HTTP response");
            }
            ++count;
        }
        StatusLine statusline = BasicStatusLine.parse(this.buffer, 0, this.buffer.length());
        return this.responsefactory.newHttpResponse(statusline, null);
    }

    protected void readResponseHeaders(HttpResponse response) throws HttpException, IOException {
        Header[] headers = HeaderUtils.parseHeaders(this.datareceiver, this.maxHeaderCount, this.maxLineLen);
        response.setHeaders(headers);
    }

    public boolean isStale() {
        this.assertOpen();
        try {
            this.datareceiver.isDataAvailable(1);
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    public HttpConnectionMetrics getMetrics() {
        return this.metrics;
    }
}

