/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerResolver;

public class HttpRequestHandlerRegistry
implements HttpRequestHandlerResolver {
    private final Map handlerMap = new HashMap();

    public void register(String pattern, HttpRequestHandler handler) {
        if (pattern == null) {
            throw new IllegalArgumentException("URI request pattern may not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("HTTP request handelr may not be null");
        }
        this.handlerMap.put(pattern, handler);
    }

    public void unregister(String pattern) {
        if (pattern == null) {
            return;
        }
        this.handlerMap.remove(pattern);
    }

    public void setHandlers(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map of handlers may not be null");
        }
        this.handlerMap.clear();
        this.handlerMap.putAll(map);
    }

    public HttpRequestHandler lookup(String requestURI) {
        Object handler;
        if (requestURI == null) {
            throw new IllegalArgumentException("Request URI may not be null");
        }
        int index = requestURI.indexOf("?");
        if (index != -1) {
            requestURI = requestURI.substring(0, index);
        }
        if ((handler = this.handlerMap.get(requestURI)) == null) {
            String bestMatch = null;
            Iterator it = this.handlerMap.keySet().iterator();
            while (it.hasNext()) {
                String pattern = (String)it.next();
                if (!this.matchUriRequestPattern(pattern, requestURI) || bestMatch != null && bestMatch.length() >= pattern.length() && (bestMatch.length() != pattern.length() || !pattern.endsWith("*"))) continue;
                handler = this.handlerMap.get(pattern);
                bestMatch = pattern;
            }
        }
        return (HttpRequestHandler)handler;
    }

    protected boolean matchUriRequestPattern(String pattern, String requestUri) {
        if (pattern.equals("*")) {
            return true;
        }
        return pattern.endsWith("*") && requestUri.startsWith(pattern.substring(0, pattern.length() - 1)) || pattern.startsWith("*") && requestUri.endsWith(pattern.substring(1, pattern.length()));
    }
}

