/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import com.google.common.collect.ImmutableList;
import io.appium.java_client.internal.CapabilityHelpers;
import io.appium.java_client.pagefactory.AppiumElementLocatorFactory;
import io.appium.java_client.pagefactory.DefaultElementByBuilder;
import io.appium.java_client.pagefactory.ElementInterceptor;
import io.appium.java_client.pagefactory.ElementListInterceptor;
import io.appium.java_client.pagefactory.OverrideWidgetReader;
import io.appium.java_client.pagefactory.Widget;
import io.appium.java_client.pagefactory.WidgetByBuilder;
import io.appium.java_client.pagefactory.WidgetConstructorUtil;
import io.appium.java_client.pagefactory.WidgetInterceptor;
import io.appium.java_client.pagefactory.WidgetListInterceptor;
import io.appium.java_client.pagefactory.bys.ContentType;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import io.appium.java_client.pagefactory.utils.ProxyFactory;
import io.appium.java_client.pagefactory.utils.WebDriverUnpackUtility;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class AppiumFieldDecorator
implements FieldDecorator {
    private static final List<Class<? extends WebElement>> availableElementClasses = ImmutableList.of(WebElement.class, RemoteWebElement.class);
    public static final Duration DEFAULT_WAITING_TIMEOUT = Duration.ofSeconds(1L);
    private final WebDriver webDriver;
    private final DefaultFieldDecorator defaultElementFieldDecoracor;
    private final AppiumElementLocatorFactory widgetLocatorFactory;
    private final String platform;
    private final String automation;
    private final Duration duration;

    public AppiumFieldDecorator(SearchContext context, Duration duration) {
        this.webDriver = WebDriverUnpackUtility.unpackWebDriverFromSearchContext(context);
        if (this.webDriver instanceof HasCapabilities) {
            Capabilities caps = ((HasCapabilities)this.webDriver).getCapabilities();
            this.platform = CapabilityHelpers.getCapability(caps, "platformName", String.class);
            this.automation = CapabilityHelpers.getCapability(caps, "automationName", String.class);
        } else {
            this.platform = null;
            this.automation = null;
        }
        this.duration = duration;
        this.defaultElementFieldDecoracor = new DefaultFieldDecorator(new AppiumElementLocatorFactory(context, duration, new DefaultElementByBuilder(this.platform, this.automation))){

            protected WebElement proxyForLocator(ClassLoader ignored, ElementLocator locator) {
                return AppiumFieldDecorator.this.proxyForAnElement(locator);
            }

            protected List<WebElement> proxyForListLocator(ClassLoader ignored, ElementLocator locator) {
                ElementListInterceptor elementInterceptor = new ElementListInterceptor(locator);
                return ProxyFactory.getEnhancedProxy(ArrayList.class, elementInterceptor);
            }

            protected boolean isDecoratableList(Field field) {
                if (!List.class.isAssignableFrom(field.getType())) {
                    return false;
                }
                Type genericType = field.getGenericType();
                if (!(genericType instanceof ParameterizedType)) {
                    return false;
                }
                Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                List bounds = listType instanceof TypeVariable ? Arrays.asList(((TypeVariable)listType).getBounds()) : Collections.emptyList();
                return availableElementClasses.stream().anyMatch(webElClass -> webElClass.equals(listType) || bounds.contains(webElClass));
            }
        };
        this.widgetLocatorFactory = new AppiumElementLocatorFactory(context, duration, new WidgetByBuilder(this.platform, this.automation));
    }

    public AppiumFieldDecorator(SearchContext context) {
        this(context, DEFAULT_WAITING_TIMEOUT);
    }

    public Object decorate(ClassLoader ignored, Field field) {
        Object result = this.defaultElementFieldDecoracor.decorate(ignored, field);
        if (result != null) {
            return result;
        }
        return this.decorateWidget(field);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object decorateWidget(Field field) {
        Class widgetType;
        Class<?> type = field.getType();
        if (!Widget.class.isAssignableFrom(type) && !List.class.isAssignableFrom(type)) {
            return null;
        }
        boolean isAlist = false;
        if (List.class.isAssignableFrom(type)) {
            isAlist = true;
            Type genericType = field.getGenericType();
            if (!(genericType instanceof ParameterizedType)) {
                return null;
            }
            Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (ParameterizedType.class.isAssignableFrom(listType.getClass())) {
                listType = ((ParameterizedType)listType).getRawType();
            }
            if (!(listType instanceof Class)) return null;
            if (!Widget.class.isAssignableFrom((Class)listType)) {
                return null;
            }
            widgetType = (Class)listType;
        } else {
            widgetType = field.getType();
        }
        CacheableLocator locator = this.widgetLocatorFactory.createLocator(field);
        Map<ContentType, Constructor<? extends Widget>> map = OverrideWidgetReader.read(widgetType, field, this.platform);
        if (isAlist) {
            return ProxyFactory.getEnhancedProxy(ArrayList.class, new WidgetListInterceptor(locator, this.webDriver, map, widgetType, this.duration));
        }
        Constructor<? extends Widget> constructor = WidgetConstructorUtil.findConvenientConstructor(widgetType);
        return ProxyFactory.getEnhancedProxy(widgetType, new Class[]{constructor.getParameterTypes()[0]}, new Object[]{this.proxyForAnElement(locator)}, new WidgetInterceptor(locator, this.webDriver, null, map, this.duration));
    }

    private WebElement proxyForAnElement(ElementLocator locator) {
        ElementInterceptor elementInterceptor = new ElementInterceptor(locator, this.webDriver);
        return (WebElement)ProxyFactory.getEnhancedProxy(RemoteWebElement.class, elementInterceptor);
    }
}

