/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory.bys.builder;

import io.appium.java_client.pagefactory.bys.builder.AnnotatedElementContainer;
import io.appium.java_client.pagefactory.bys.builder.ByAll;
import io.appium.java_client.pagefactory.bys.builder.ByChained;
import io.appium.java_client.pagefactory.bys.builder.HowToUseSelectors;
import io.appium.java_client.pagefactory.bys.builder.Strategies;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.support.pagefactory.AbstractAnnotations;

public abstract class AppiumByBuilder
extends AbstractAnnotations {
    protected static final Class<?>[] DEFAULT_ANNOTATION_METHOD_ARGUMENTS = new Class[0];
    private static final List<String> METHODS_TO_BE_EXCLUDED_WHEN_ANNOTATION_IS_READ = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            Stream.of(Object.class, Annotation.class, Proxy.class).map(Class::getDeclaredMethods).map(x$0 -> AppiumByBuilder.getMethodNames(x$0)).flatMap(Collection::stream).forEach(this::add);
        }
    };
    protected final AnnotatedElementContainer annotatedElementContainer = new AnnotatedElementContainer();
    protected final String platform;
    protected final String automation;

    protected AppiumByBuilder(String platform, String automation) {
        this.platform = String.valueOf(platform);
        this.automation = String.valueOf(automation);
    }

    private static List<String> getMethodNames(Method[] methods) {
        return Stream.of(methods).map(Method::getName).collect(Collectors.toList());
    }

    private static Method[] prepareAnnotationMethods(Class<? extends Annotation> annotation) {
        List<String> targetAnnotationMethodNamesList = AppiumByBuilder.getMethodNames(annotation.getDeclaredMethods());
        targetAnnotationMethodNamesList.removeAll(METHODS_TO_BE_EXCLUDED_WHEN_ANNOTATION_IS_READ);
        return (Method[])targetAnnotationMethodNamesList.stream().map(methodName -> {
            try {
                return annotation.getMethod((String)methodName, DEFAULT_ANNOTATION_METHOD_ARGUMENTS);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }).toArray(Method[]::new);
    }

    private static String getFilledValue(Annotation mobileBy) {
        return Stream.of(AppiumByBuilder.prepareAnnotationMethods(mobileBy.getClass())).filter(method -> String.class == method.getReturnType()).filter(method -> {
            try {
                Object strategyParameter = method.invoke((Object)mobileBy, new Object[0]);
                return strategyParameter != null && !String.valueOf(strategyParameter).isEmpty();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).findFirst().map(Method::getName).orElseThrow(() -> new IllegalArgumentException(String.format("@%s: one of %s should be filled", mobileBy.getClass().getSimpleName(), Strategies.strategiesNames())));
    }

    private static By getMobileBy(Annotation annotation, String valueName) {
        return Stream.of(Strategies.values()).filter(strategy -> strategy.returnValueName().equals(valueName)).findFirst().map(strategy -> strategy.getBy(annotation)).orElseThrow(() -> new IllegalArgumentException(String.format("@%s: There is an unknown strategy %s", annotation.getClass().getSimpleName(), valueName)));
    }

    private static <T extends By> T getComplexMobileBy(Annotation[] annotations, Class<T> requiredByClass) {
        By[] byArray = (By[])Stream.of(annotations).map(annotation -> AppiumByBuilder.getMobileBy(annotation, AppiumByBuilder.getFilledValue(annotation))).toArray(By[]::new);
        try {
            Constructor<T> c = requiredByClass.getConstructor(By[].class);
            Object[] values = new Object[]{byArray};
            return (T)((By)c.newInstance(values));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    protected static By createBy(Annotation[] annotations, HowToUseSelectors howToUseLocators) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        switch (howToUseLocators) {
            case USE_ONE: {
                return AppiumByBuilder.getMobileBy(annotations[0], AppiumByBuilder.getFilledValue(annotations[0]));
            }
            case BUILD_CHAINED: {
                return AppiumByBuilder.getComplexMobileBy(annotations, ByChained.class);
            }
            case USE_ANY: {
                return AppiumByBuilder.getComplexMobileBy(annotations, ByAll.class);
            }
        }
        return null;
    }

    public void setAnnotated(AnnotatedElement annotated) {
        this.annotatedElementContainer.setAnnotated(annotated);
    }

    protected boolean isAndroid() {
        return "Android".equalsIgnoreCase(this.platform);
    }

    protected boolean isIOS() {
        return "iOS".equalsIgnoreCase(this.platform);
    }

    protected boolean isTvOS() {
        return "tvOS".equalsIgnoreCase(this.platform);
    }

    protected boolean isIOSXcuit() {
        return this.isIOS() && "XCuiTest".equalsIgnoreCase(this.automation);
    }

    protected boolean isWindows() {
        return "Windows".equalsIgnoreCase(this.platform);
    }

    public abstract By buildBy();

    public abstract boolean isLookupCached();

    protected abstract By buildDefaultBy();

    protected abstract By buildMobileNativeBy();

    protected abstract void assertValidAnnotations();
}

