/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.journal.impl.JournalCompactor;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalRecord;
import org.hornetq.core.journal.impl.JournalRecordProvider;
import org.hornetq.core.journal.impl.TransactionCallback;
import org.hornetq.core.journal.impl.dataformat.JournalInternalRecord;

public class JournalTransaction {
    private JournalRecordProvider journal;
    private List<JournalUpdate> pos;
    private List<JournalUpdate> neg;
    private final long id;
    private Set<JournalFile> pendingFiles;
    private TransactionCallback currentCallback;
    private boolean compacting = false;
    private Map<JournalFile, TransactionCallback> callbackList;
    private JournalFile lastFile = null;
    private final AtomicInteger counter = new AtomicInteger();

    public JournalTransaction(long id, JournalRecordProvider journal) {
        this.id = id;
        this.journal = journal;
    }

    public void replaceRecordProvider(JournalRecordProvider provider) {
        this.journal = provider;
    }

    public long getId() {
        return this.id;
    }

    public int getCounter(JournalFile file) {
        return this.internalgetCounter(file).intValue();
    }

    public void incCounter(JournalFile file) {
        this.internalgetCounter(file).incrementAndGet();
    }

    public long[] getPositiveArray() {
        if (this.pos == null) {
            return new long[0];
        }
        int i = 0;
        long[] ids = new long[this.pos.size()];
        for (JournalUpdate el : this.pos) {
            ids[i++] = el.getId();
        }
        return ids;
    }

    public void setCompacting() {
        this.compacting = true;
        this.clear();
    }

    public void merge(JournalTransaction other) {
        if (other.pos != null) {
            if (this.pos == null) {
                this.pos = new ArrayList<JournalUpdate>();
            }
            this.pos.addAll(other.pos);
        }
        if (other.neg != null) {
            if (this.neg == null) {
                this.neg = new ArrayList<JournalUpdate>();
            }
            this.neg.addAll(other.neg);
        }
        if (other.pendingFiles != null) {
            if (this.pendingFiles == null) {
                this.pendingFiles = new HashSet<JournalFile>();
            }
            this.pendingFiles.addAll(other.pendingFiles);
        }
        this.compacting = false;
    }

    public void clear() {
        if (this.pendingFiles != null) {
            this.pendingFiles.clear();
        }
        if (this.callbackList != null) {
            this.callbackList.clear();
        }
        if (this.pos != null) {
            this.pos.clear();
        }
        if (this.neg != null) {
            this.neg.clear();
        }
        this.counter.set(0);
        this.lastFile = null;
        this.currentCallback = null;
    }

    public void fillNumberOfRecords(JournalFile currentFile, JournalInternalRecord data) {
        data.setNumberOfRecords(this.getCounter(currentFile));
    }

    public TransactionCallback getCallback(JournalFile file) throws Exception {
        if (this.callbackList == null) {
            this.callbackList = new HashMap<JournalFile, TransactionCallback>();
        }
        this.currentCallback = this.callbackList.get(file);
        if (this.currentCallback == null) {
            this.currentCallback = new TransactionCallback();
            this.callbackList.put(file, this.currentCallback);
        }
        if (this.currentCallback.getErrorMessage() != null) {
            throw new HornetQException(this.currentCallback.getErrorCode(), this.currentCallback.getErrorMessage());
        }
        this.currentCallback.countUp();
        return this.currentCallback;
    }

    public void addPositive(JournalFile file, long id, int size) {
        this.incCounter(file);
        this.addFile(file);
        if (this.pos == null) {
            this.pos = new ArrayList<JournalUpdate>();
        }
        this.pos.add(new JournalUpdate(file, id, size));
    }

    public void addNegative(JournalFile file, long id) {
        this.incCounter(file);
        this.addFile(file);
        if (this.neg == null) {
            this.neg = new ArrayList<JournalUpdate>();
        }
        this.neg.add(new JournalUpdate(file, id, 0));
    }

    public void commit(JournalFile file) {
        JournalCompactor compactor = this.journal.getCompactor();
        if (this.compacting) {
            compactor.addCommandCommit(this, file);
        } else {
            JournalRecord posFiles;
            if (this.pos != null) {
                for (JournalUpdate trUpdate : this.pos) {
                    posFiles = this.journal.getRecords().get(trUpdate.id);
                    if (compactor != null && compactor.lookupRecord(trUpdate.id)) {
                        compactor.addCommandUpdate(trUpdate.id, trUpdate.file, trUpdate.size);
                        continue;
                    }
                    if (posFiles == null) {
                        posFiles = new JournalRecord(trUpdate.file, trUpdate.size);
                        this.journal.getRecords().put(trUpdate.id, posFiles);
                        continue;
                    }
                    posFiles.addUpdateFile(trUpdate.file, trUpdate.size);
                }
            }
            if (this.neg != null) {
                for (JournalUpdate trDelete : this.neg) {
                    if (compactor != null) {
                        compactor.addCommandDelete(trDelete.id, trDelete.file);
                        continue;
                    }
                    posFiles = this.journal.getRecords().remove(trDelete.id);
                    if (posFiles == null) continue;
                    posFiles.delete(trDelete.file);
                }
            }
            for (JournalFile jf : this.pendingFiles) {
                file.incNegCount(jf);
            }
        }
    }

    public void waitCallbacks() throws Exception {
        if (this.callbackList != null) {
            for (TransactionCallback callback : this.callbackList.values()) {
                callback.waitCompletion();
            }
        }
    }

    public void waitCompletion() throws Exception {
        if (this.currentCallback != null) {
            this.currentCallback.waitCompletion();
        }
    }

    public void rollback(JournalFile file) {
        JournalCompactor compactor = this.journal.getCompactor();
        if (this.compacting && compactor != null) {
            compactor.addCommandRollback(this, file);
        } else {
            for (JournalFile jf : this.pendingFiles) {
                file.incNegCount(jf);
            }
        }
    }

    public void prepare(JournalFile file) {
        this.addFile(file);
    }

    public void forget() {
        for (JournalFile jf : this.pendingFiles) {
            jf.decPosCount();
        }
    }

    public String toString() {
        return "JournalTransaction(" + this.id + ")";
    }

    private AtomicInteger internalgetCounter(JournalFile file) {
        if (this.lastFile != file) {
            this.lastFile = file;
            this.counter.set(0);
        }
        return this.counter;
    }

    private void addFile(JournalFile file) {
        if (this.pendingFiles == null) {
            this.pendingFiles = new HashSet<JournalFile>();
        }
        if (!this.pendingFiles.contains(file)) {
            this.pendingFiles.add(file);
            file.incPosCount();
        }
    }

    static class JournalUpdate {
        JournalFile file;
        long id;
        int size;

        public JournalUpdate(JournalFile file, long id, int size) {
            this.file = file;
            this.id = id;
            this.size = size;
        }

        public JournalFile getFile() {
            return this.file;
        }

        public long getId() {
            return this.id;
        }

        public int getSize() {
            return this.size;
        }
    }
}

