/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.xml.ws.WebServiceContext;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.injection.InjectionException;
import org.jboss.ws.common.injection.finders.PostConstructMethodFinder;
import org.jboss.ws.common.injection.finders.PreDestroyMethodFinder;
import org.jboss.ws.common.injection.finders.ResourceFieldFinder;
import org.jboss.ws.common.injection.finders.ResourceMethodFinder;
import org.jboss.ws.common.reflection.ClassProcessor;

public final class InjectionHelper {
    private static final ResourceBundle bundle = BundleUtils.getBundle(InjectionHelper.class);
    private static final Logger LOG = Logger.getLogger(InjectionHelper.class);
    private static final ClassProcessor<Method> POST_CONSTRUCT_METHOD_FINDER = new PostConstructMethodFinder();
    private static final ClassProcessor<Method> PRE_DESTROY_METHOD_FINDER = new PreDestroyMethodFinder();
    private static final ClassProcessor<Method> WEB_SERVICE_CONTEXT_METHOD_FINDER = new ResourceMethodFinder(WebServiceContext.class, true);
    private static final ClassProcessor<Field> WEB_SERVICE_CONTEXT_FIELD_FINDER = new ResourceFieldFinder(WebServiceContext.class, true);

    private InjectionHelper() {
    }

    public static void injectWebServiceContext(Object instance, WebServiceContext ctx) {
        Class<?> instanceClass = instance.getClass();
        Collection<Method> resourceAnnotatedMethods = WEB_SERVICE_CONTEXT_METHOD_FINDER.process(instanceClass);
        for (Method method : resourceAnnotatedMethods) {
            try {
                InjectionHelper.invokeMethod(instance, method, new Object[]{ctx});
            }
            catch (Exception e) {
                String message = "Cannot inject @Resource annotated method: " + method;
                InjectionException.rethrow(message, e);
            }
        }
        Collection<Field> resourceAnnotatedFields = WEB_SERVICE_CONTEXT_FIELD_FINDER.process(instanceClass);
        for (Field field : resourceAnnotatedFields) {
            try {
                InjectionHelper.setField(instance, field, ctx);
            }
            catch (Exception e) {
                String message = "Cannot inject @Resource annotated field: " + field;
                InjectionException.rethrow(message, e);
            }
        }
    }

    public static void callPostConstructMethod(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"OBJECT_INSTANCE_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        Collection<Method> methods = POST_CONSTRUCT_METHOD_FINDER.process(instance.getClass());
        if (methods.size() > 0) {
            Method method = methods.iterator().next();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Calling @PostConstruct annotated method: " + method));
            }
            try {
                InjectionHelper.invokeMethod(instance, method, null);
            }
            catch (Exception e) {
                String message = "Calling of @PostConstruct annotated method failed: " + method;
                InjectionException.rethrow(message, e);
            }
        }
    }

    public static void callPreDestroyMethod(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"OBJECT_INSTANCE_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        Collection<Method> methods = PRE_DESTROY_METHOD_FINDER.process(instance.getClass());
        if (methods.size() > 0) {
            Method method = methods.iterator().next();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Calling @PreDestroy annotated method: " + method));
            }
            try {
                InjectionHelper.invokeMethod(instance, method, null);
            }
            catch (Exception e) {
                String message = "Calling of @PreDestroy annotated method failed: " + method;
                InjectionException.rethrow(message, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeMethod(Object instance, Method method, Object[] args) {
        boolean accessability = method.isAccessible();
        try {
            method.setAccessible(true);
            method.invoke(instance, args);
        }
        catch (Exception e) {
            InjectionException.rethrow(e);
        }
        finally {
            method.setAccessible(accessability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setField(Object instance, Field field, Object value) {
        boolean accessability = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            InjectionException.rethrow(e);
        }
        finally {
            field.setAccessible(accessability);
        }
    }
}

