/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.management;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.framework.Services;
import org.osgi.service.startlevel.StartLevel;

public abstract class StartLevelHandler
implements OperationStepHandler {
    public static final StartLevelHandler READ_HANDLER = new StartLevelHandler(){

        @Override
        void invokeOperation(StartLevel startLevel, OperationContext context, ModelNode operation) {
            int level = startLevel.getStartLevel();
            context.getResult().set(level);
        }
    };
    public static final StartLevelHandler WRITE_HANDLER = new StartLevelHandler(){

        @Override
        void invokeOperation(StartLevel startLevel, OperationContext context, ModelNode operation) {
            int targetStartLevel = operation.require("value").asInt();
            startLevel.setStartLevel(targetStartLevel);
        }
    };

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServiceController controller = context.getServiceRegistry(false).getService(Services.START_LEVEL);
        if (controller != null && controller.getState() == ServiceController.State.UP) {
            StartLevel startLevel = (StartLevel)controller.getValue();
            this.invokeOperation(startLevel, context, operation);
        } else {
            context.getResult().set(new ModelNode());
        }
        context.completeStep();
    }

    abstract void invokeOperation(StartLevel var1, OperationContext var2, ModelNode var3);
}

