/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ds.processors;

import java.lang.reflect.Constructor;
import java.sql.Driver;
import java.util.List;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.driver.DriverService;
import org.jboss.as.connector.services.driver.InstalledDriver;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public final class DriverProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            ModuleClassLoader classLoader = module.getClassLoader();
            List driverNames = servicesAttachment.getServiceImplementations(Driver.class.getName());
            for (String driverClassName : driverNames) {
                try {
                    Class<Driver> driverClass = classLoader.loadClass(driverClassName).asSubclass(Driver.class);
                    Constructor<Driver> constructor = driverClass.getConstructor(new Class[0]);
                    Driver driver = constructor.newInstance(new Object[0]);
                    int majorVersion = driver.getMajorVersion();
                    int minorVersion = driver.getMinorVersion();
                    boolean compliant = driver.jdbcCompliant();
                    if (compliant) {
                        ConnectorLogger.DEPLOYER_JDBC_LOGGER.deployingCompliantJdbcDriver(driverClass, majorVersion, minorVersion);
                    } else {
                        ConnectorLogger.DEPLOYER_JDBC_LOGGER.deployingNonCompliantJdbcDriver(driverClass, majorVersion, minorVersion);
                    }
                    String driverName = driverNames.size() == 1 ? deploymentUnit.getName() : deploymentUnit.getName() + driverClassName + "_" + majorVersion + "_" + minorVersion;
                    InstalledDriver driverMetadata = new InstalledDriver(driverName, driverClass.getName(), null, null, majorVersion, minorVersion, compliant);
                    DriverService driverService = new DriverService(driverMetadata, driver);
                    phaseContext.getServiceTarget().addService(ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")}), (Service)driverService).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, driverService.getDriverRegistryServiceInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                }
                catch (Exception e) {
                    ConnectorLogger.DEPLOYER_JDBC_LOGGER.cannotInstantiateDriverClass(driverClassName, e);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

