/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.executor;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.JChannel;
import org.jgroups.blocks.executor.ExecutorEvent;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.Executing;

public class ExecutionRunner
implements Runnable {
    protected JChannel ch;
    protected Executing _execProt;
    protected static final Log _logger = LogFactory.getLog(ExecutionRunner.class);

    public ExecutionRunner(JChannel channel) {
        this.setChannel(channel);
    }

    public void setChannel(JChannel ch) {
        this.ch = ch;
        this._execProt = (Executing)ch.getProtocolStack().findProtocol((Class<?>)Executing.class);
        if (this._execProt == null) {
            throw new IllegalStateException("Channel configuration must include a executing protocol (subclass of " + Executing.class.getName() + ")");
        }
    }

    @Override
    public void run() {
        block2: {
            final AtomicBoolean shutdown = new AtomicBoolean();
            Thread executionThread = new Thread(){

                @Override
                public void run() {
                    Object[] runnable = null;
                    while (!shutdown.get()) {
                        Object[] objectArray;
                        runnable = (Object[])ExecutionRunner.this.ch.down(new ExecutorEvent(1025, null));
                        if (Thread.interrupted()) {
                            if (runnable == null) continue;
                            ExecutionRunner.this.ch.down(new ExecutorEvent(1026, new Object[]{runnable, new InterruptedException()}));
                            continue;
                        }
                        Throwable throwable = null;
                        try {
                            runnable.run();
                        }
                        catch (Throwable t) {
                            _logger.error("Unexpected Runtime Error encountered in Runnable request", t);
                            throwable = t;
                        }
                        JChannel jChannel = ExecutionRunner.this.ch;
                        if (throwable != null) {
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = runnable;
                            objectArray = objectArray2;
                            objectArray2[1] = throwable;
                        } else {
                            objectArray = runnable;
                        }
                        jChannel.down(new ExecutorEvent(1026, objectArray));
                    }
                }
            };
            executionThread.setName(Thread.currentThread().getName() + "- Task Runner");
            executionThread.start();
            try {
                executionThread.join();
            }
            catch (InterruptedException e) {
                shutdown.set(true);
                executionThread.interrupt();
                if (!_logger.isTraceEnabled()) break block2;
                _logger.trace("Shutting down Execution Runner");
            }
        }
    }
}

