/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.modcluster.CustomLoadMetricDefinition;
import org.jboss.as.modcluster.DynamicLoadProviderDefinition;
import org.jboss.as.modcluster.LoadMetricDefinition;
import org.jboss.as.modcluster.ModClusterConfigResourceDefinition;
import org.jboss.as.modcluster.ModClusterDefinition;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.modcluster.ModClusterSSLResourceDefinition;
import org.jboss.as.modcluster.ModClusterSubsystemXMLWriter;
import org.jboss.as.modcluster.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class ModClusterExtension
implements XMLStreamConstants,
Extension {
    public static final String SUBSYSTEM_NAME = "modcluster";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"modcluster");
    static final PathElement CONFIGURATION_PATH = PathElement.pathElement((String)"mod-cluster-config", (String)"configuration");
    static final PathElement SSL_CONFIGURATION_PATH = PathElement.pathElement((String)"ssl", (String)"configuration");
    static final PathElement DYNAMIC_LOAD_PROVIDER = PathElement.pathElement((String)"dynamic-load-provider", (String)"configuration");
    static final PathElement LOAD_METRIC = PathElement.pathElement((String)"load-metric");
    static final PathElement CUSTOM_LOAD_METRIC = PathElement.pathElement((String)"custom-load-metric");
    private static final String RESOURCE_NAME = ModClusterExtension.class.getPackage().getName() + ".LocalDescriptions";

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, ModClusterExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        ModClusterLogger.ROOT_LOGGER.debugf("Activating Mod_cluster Extension", new Object[0]);
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new ModClusterDefinition(context.isRuntimeOnlyRegistrationValid()));
        ManagementResourceRegistration configuration = registration.registerSubModel((ResourceDefinition)new ModClusterConfigResourceDefinition());
        configuration.registerSubModel((ResourceDefinition)new ModClusterSSLResourceDefinition());
        ManagementResourceRegistration dynamicLoadProvider = configuration.registerSubModel((ResourceDefinition)DynamicLoadProviderDefinition.INSTANCE);
        dynamicLoadProvider.registerSubModel((ResourceDefinition)LoadMetricDefinition.INSTANCE);
        dynamicLoadProvider.registerSubModel((ResourceDefinition)CustomLoadMetricDefinition.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)new ModClusterSubsystemXMLWriter());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), namespace.getXMLReader());
        }
    }
}

