/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jboss.as.cli.gui.CommandExecutor;
import org.jboss.as.cli.gui.CommandLine;
import org.jboss.dmr.ModelNode;

public class CliGuiContext {
    private CommandExecutor executor;
    private JPanel mainPanel;
    private CommandLine cmdLine;
    private boolean isStandalone;

    CliGuiContext() {
    }

    void setExecutor(CommandExecutor executor) {
        this.executor = executor;
        try {
            ModelNode result = executor.doCommand("/:read-attribute(name=process-type)");
            this.isStandalone = result.get("result").asString().equals("Server");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setMainPanel(JPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    void setCommandLine(CommandLine cmdLine) {
        this.cmdLine = cmdLine;
    }

    public boolean isStandalone() {
        return this.isStandalone;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public Window getMainWindow() {
        return SwingUtilities.getWindowAncestor(this.mainPanel);
    }

    public CommandLine getCommandLine() {
        return this.cmdLine;
    }

    public CommandExecutor getExecutor() {
        return this.executor;
    }
}

