/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.CacheException;
import org.infinispan.distribution.ch.AbstractConsistentHash;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Immutables;
import org.infinispan.util.Util;

public class UnionConsistentHash
extends AbstractConsistentHash {
    ConsistentHash oldCH;
    ConsistentHash newCH;

    public UnionConsistentHash(ConsistentHash oldCH, ConsistentHash newCH) {
        if (oldCH instanceof UnionConsistentHash || newCH instanceof UnionConsistentHash) {
            throw new CacheException("Expecting both newCH and oldCH to not be Unions!!  oldCH=[" + oldCH.getClass() + "] and newCH=[" + newCH.getClass() + "]");
        }
        this.oldCH = oldCH;
        this.newCH = newCH;
    }

    @Override
    public void setCaches(Set<Address> caches) {
    }

    @Override
    public Set<Address> getCaches() {
        return Collections.emptySet();
    }

    @Override
    public List<Address> locate(Object key, int replCount) {
        LinkedHashSet<Address> addresses = new LinkedHashSet<Address>();
        addresses.addAll(this.oldCH.locate(key, replCount));
        addresses.addAll(this.newCH.locate(key, replCount));
        return Immutables.immutableListConvert(addresses);
    }

    @Override
    public List<Integer> getHashIds(Address a) {
        throw new UnsupportedOperationException("Unsupported!");
    }

    public ConsistentHash getNewConsistentHash() {
        return this.newCH;
    }

    public ConsistentHash getOldConsistentHash() {
        return this.oldCH;
    }

    public static class Externalizer
    extends AbstractExternalizer<UnionConsistentHash> {
        @Override
        public void writeObject(ObjectOutput output, UnionConsistentHash uch) throws IOException {
            output.writeObject(uch.oldCH);
            output.writeObject(uch.newCH);
        }

        @Override
        public UnionConsistentHash readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new UnionConsistentHash((ConsistentHash)input.readObject(), (ConsistentHash)input.readObject());
        }

        @Override
        public Integer getId() {
            return 52;
        }

        @Override
        public Set<Class<? extends UnionConsistentHash>> getTypeClasses() {
            return Util.asSet(UnionConsistentHash.class);
        }
    }
}

