/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class HandlerFileService
implements Service<String> {
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private String path;
    private String relativeTo;
    private String fileName;
    private PathManager.Callback.Handle callbackHandle;

    public HandlerFileService(String path, String relativeTo) {
        this.path = path;
        this.relativeTo = relativeTo;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.fileName = ((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(this.path, this.relativeTo);
        if (this.relativeTo == null) {
            this.callbackHandle = ((PathManager)this.pathManager.getValue()).registerCallback(this.relativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
        }
    }

    public synchronized void stop(StopContext context) {
        this.fileName = null;
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
    }

    public synchronized void setPath(String path) {
        this.path = path;
        this.fileName = ((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(path, this.relativeTo);
    }

    public String getValue() throws IllegalStateException, IllegalArgumentException {
        return this.fileName;
    }

    public Injector<PathManager> getPathManagerInjector() {
        return this.pathManager;
    }
}

