/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.component;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalHome;
import javax.transaction.Transaction;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.TransactionEntityMap;
import org.jboss.as.cmp.component.Cmp10AllowedMethodsInformation;
import org.jboss.as.cmp.component.CmpAllowedMethodsInformation;
import org.jboss.as.cmp.component.CmpEntityBeanComponentCreateService;
import org.jboss.as.cmp.component.CmpEntityBeanComponentInstance;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.bridge.CMRMessage;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentCreateService;
import org.jboss.as.ejb3.component.entity.entitycache.ReadyEntityCache;
import org.jboss.as.ejb3.component.entity.entitycache.TransactionLocalEntityCache;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.msc.value.Value;

public class CmpEntityBeanComponent
extends EntityBeanComponent {
    private final Value<JDBCEntityPersistenceStore> storeManager;
    private final InterceptorFactory relationInterceptorFactory;
    private final boolean cmp10;
    private boolean ejbStoreForClean;
    private final TransactionEntityMap transactionEntityMap;

    public CmpEntityBeanComponent(CmpEntityBeanComponentCreateService ejbComponentCreateService, Value<JDBCEntityPersistenceStore> storeManager) {
        super((EntityBeanComponentCreateService)ejbComponentCreateService);
        this.storeManager = storeManager;
        this.relationInterceptorFactory = ejbComponentCreateService.getRelationInterceptorFactory();
        this.transactionEntityMap = ejbComponentCreateService.getTransactionEntityMap();
        this.cmp10 = ejbComponentCreateService.getEntityMetaData().isCMP1x();
    }

    protected BasicComponentInstance instantiateComponentInstance(AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, InterceptorFactoryContext interceptorContext) {
        SimpleInterceptorFactoryContext context = new SimpleInterceptorFactoryContext();
        context.getContextData().put(Component.class, this);
        Interceptor interceptor = this.relationInterceptorFactory.create((InterceptorFactoryContext)context);
        return new CmpEntityBeanComponentInstance((BasicComponent)this, instanceReference, preDestroyInterceptor, methodInterceptors, interceptor);
    }

    public void start() {
        super.start();
        if (this.storeManager == null || this.storeManager.getValue() == null) {
            throw CmpMessages.MESSAGES.notStoreMangerForComponent(this.getComponentName());
        }
    }

    public Collection<Object> getEntityLocalCollection(List<Object> idList) {
        return null;
    }

    public void synchronizeEntitiesWithinTransaction(Transaction transaction) {
        if (transaction != null) {
            this.getTransactionEntityMap().synchronizeEntities(transaction);
        }
    }

    public EJBLocalHome getEJBLocalHome() throws IllegalStateException {
        return (EJBLocalHome)this.createViewInstanceProxy(this.getLocalHomeClass(), Collections.emptyMap());
    }

    public JDBCEntityPersistenceStore getStoreManager() {
        return (JDBCEntityPersistenceStore)this.storeManager.getValue();
    }

    public Object invoke(CMRMessage message, Object key, Object ... params) throws Exception {
        CmpEntityBeanComponentInstance instance = (CmpEntityBeanComponentInstance)this.getCache().get(key);
        return instance.invoke(message, params);
    }

    public void invokeEjbStore(CmpEntityBeanContext ctx) throws Exception {
        if (ctx.getPrimaryKey() != null) {
            if (this.ejbStoreForClean) {
                try {
                    ctx.getInstance().ejbStore();
                }
                catch (Exception e) {
                    this.throwRemoteException(e);
                }
            } else {
                boolean modified = false;
                try {
                    modified = this.getStoreManager().isStoreRequired(ctx);
                }
                catch (Exception e) {
                    this.throwRemoteException(e);
                }
                if (modified) {
                    try {
                        ctx.getInstance().ejbStore();
                    }
                    catch (Exception e) {
                        this.throwRemoteException(e);
                    }
                }
            }
        }
    }

    public void storeEntity(CmpEntityBeanContext ctx) throws Exception {
        if (ctx.getPrimaryKey() != null && this.getStoreManager().isStoreRequired(ctx)) {
            this.getStoreManager().storeEntity(ctx);
        }
    }

    private void throwRemoteException(Exception e) throws RemoteException {
        if (e instanceof RemoteException) {
            throw (RemoteException)e;
        }
        if (e instanceof EJBException) {
            throw (EJBException)((Object)e);
        }
        throw new EJBException(e);
    }

    public TransactionEntityMap getTransactionEntityMap() {
        return this.transactionEntityMap;
    }

    protected ReadyEntityCache createEntityCache(EntityBeanComponentCreateService ejbComponentCreateService) {
        if (((CmpEntityBeanComponentCreateService)((Object)CmpEntityBeanComponentCreateService.class.cast(ejbComponentCreateService))).getEntityMetaData().getOptimisticLocking() == null) {
            return super.createEntityCache(ejbComponentCreateService);
        }
        return new TransactionLocalEntityCache((EntityBeanComponent)this);
    }

    public AllowedMethodsInformation getAllowedMethodsInformation() {
        if (this.cmp10) {
            return Cmp10AllowedMethodsInformation.INSTANCE;
        }
        return CmpAllowedMethodsInformation.INSTANCE;
    }
}

