/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.CMPFieldStateFactory;
import org.jboss.as.cmp.jdbc.JDBCParameterSetter;
import org.jboss.as.cmp.jdbc.JDBCResultSetReader;
import org.jboss.as.cmp.jdbc.JDBCType;
import org.jboss.as.cmp.jdbc.JDBCTypeComplex;
import org.jboss.as.cmp.jdbc.JDBCTypeComplexProperty;
import org.jboss.as.cmp.jdbc.JDBCTypeSimple;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.Mapper;
import org.jboss.as.cmp.jdbc.TCLAction;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldPropertyMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCUserTypeMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCValueClassMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCValuePropertyMetaData;

public final class JDBCTypeFactory {
    public static CMPFieldStateFactory EQUALS = new CMPFieldStateFactory(){

        @Override
        public Object getFieldState(Object fieldValue) {
            return fieldValue;
        }

        @Override
        public boolean isStateValid(Object state, Object fieldValue) {
            return state == null ? fieldValue == null : state.equals(fieldValue);
        }
    };
    private static CMPFieldStateFactory INVALID_UNLESS_NULL = new CMPFieldStateFactory(){

        @Override
        public Object getFieldState(Object fieldValue) {
            return fieldValue;
        }

        @Override
        public boolean isStateValid(Object state, Object fieldValue) {
            return state == null ? fieldValue == null : false;
        }
    };
    private static CMPFieldStateFactory MAP = new CMPFieldStateFactory(){

        @Override
        public Object getFieldState(Object fieldValue) {
            return JDBCTypeFactory.cloneValue(fieldValue, Map.class);
        }

        @Override
        public boolean isStateValid(Object state, Object fieldValue) {
            return state == null ? fieldValue == null : state.equals(fieldValue);
        }
    };
    private static CMPFieldStateFactory LIST = new CMPFieldStateFactory(){

        @Override
        public Object getFieldState(Object fieldValue) {
            return JDBCTypeFactory.cloneValue(fieldValue, Collection.class);
        }

        @Override
        public boolean isStateValid(Object state, Object fieldValue) {
            return state == null ? fieldValue == null : state.equals(fieldValue);
        }
    };
    private static CMPFieldStateFactory SET = new CMPFieldStateFactory(){

        @Override
        public Object getFieldState(Object fieldValue) {
            return JDBCTypeFactory.cloneValue(fieldValue, Collection.class);
        }

        @Override
        public boolean isStateValid(Object state, Object fieldValue) {
            return state == null ? fieldValue == null : state.equals(fieldValue);
        }
    };
    private static CMPFieldStateFactory ARRAY = new CMPFieldStateFactory(){

        @Override
        public Object getFieldState(Object fieldValue) {
            Object state = null;
            if (fieldValue != null) {
                int length = Array.getLength(fieldValue);
                state = Array.newInstance(fieldValue.getClass().getComponentType(), length);
                System.arraycopy(fieldValue, 0, state, 0, length);
            }
            return state;
        }

        @Override
        public boolean isStateValid(Object state, Object fieldValue) {
            boolean valid;
            if (state == null) {
                valid = fieldValue == null;
            } else if (fieldValue == null) {
                valid = false;
            } else {
                int stateLength = Array.getLength(state);
                if (stateLength != Array.getLength(fieldValue)) {
                    valid = false;
                } else {
                    valid = true;
                    for (int i = 0; i < stateLength; ++i) {
                        Object stateEl = Array.get(state, i);
                        Object valueEl = Array.get(fieldValue, i);
                        boolean bl = stateEl == null ? valueEl == null : (valid = stateEl.equals(valueEl));
                        if (!valid) break;
                    }
                }
            }
            return valid;
        }
    };
    private final JDBCTypeMappingMetaData typeMapping;
    private final Map complexTypes = new HashMap();
    private final Map mappedSimpleTypes = new HashMap();
    private final Map userTypeMappings;

    public static CMPFieldStateFactory getCMPFieldStateFactory(JDBCTypeFactory factory, String implClassName, Class clazz) {
        CMPFieldStateFactory stateFactory;
        JDBCUserTypeMappingMetaData userMapping;
        if (implClassName == null && (userMapping = (JDBCUserTypeMappingMetaData)factory.userTypeMappings.get(clazz.getName())) != null) {
            implClassName = userMapping.getStateFactory();
        }
        if (implClassName != null) {
            try {
                Class<?> implClass = TCLAction.UTIL.getContextClassLoader().loadClass(implClassName);
                stateFactory = (CMPFieldStateFactory)implClass.newInstance();
            }
            catch (Exception e) {
                throw CmpMessages.MESSAGES.failedToCreateFieldStateFactory(implClassName, e);
            }
        } else {
            stateFactory = Map.class.isAssignableFrom(clazz) ? MAP : (List.class.isAssignableFrom(clazz) ? LIST : (Set.class.isAssignableFrom(clazz) ? SET : (clazz.isArray() ? ARRAY : (JDBCTypeFactory.usedWithEqualsStateFactory(clazz) ? EQUALS : INVALID_UNLESS_NULL))));
        }
        return stateFactory;
    }

    public static boolean checkDirtyAfterGet(JDBCTypeFactory factory, byte checkDirtyAfterGet, Class fieldType) {
        JDBCUserTypeMappingMetaData userMapping;
        boolean result = checkDirtyAfterGet == 4 ? ((userMapping = (JDBCUserTypeMappingMetaData)factory.userTypeMappings.get(fieldType.getName())) != null && userMapping.checkDirtyAfterGet() != 4 ? userMapping.checkDirtyAfterGet() == 1 : !JDBCTypeFactory.isDefaultImmutable(fieldType)) : checkDirtyAfterGet == 1;
        return result;
    }

    private static Object cloneValue(Object fieldValue, Class argType) {
        Constructor<?> ctor;
        if (fieldValue == null) {
            return null;
        }
        Class<?> valueType = fieldValue.getClass();
        try {
            ctor = valueType.getConstructor(argType);
        }
        catch (NoSuchMethodException e) {
            throw CmpMessages.MESSAGES.failedToFindConstructor(valueType, argType);
        }
        try {
            return ctor.newInstance(fieldValue);
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.failedToConstructWithArgument(valueType, fieldValue);
        }
    }

    private static boolean usedWithEqualsStateFactory(Class clazz) {
        return JDBCTypeFactory.isDefaultImmutable(clazz) || clazz == java.util.Date.class || clazz == Date.class || clazz == Time.class || clazz == Timestamp.class;
    }

    private static boolean isDefaultImmutable(Class clazz) {
        boolean result = false;
        if (clazz.isPrimitive() || clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Character.class || clazz == String.class || clazz == BigInteger.class || clazz == BigDecimal.class) {
            result = true;
        }
        return result;
    }

    public JDBCTypeFactory(JDBCTypeMappingMetaData typeMapping, Collection valueClasses, Map userTypeMappings) {
        this.typeMapping = typeMapping;
        this.userTypeMappings = userTypeMappings;
        HashMap valueClassesByType = new HashMap();
        for (JDBCValueClassMetaData valueClass : valueClasses) {
            valueClassesByType.put(valueClass.getJavaType(), valueClass);
        }
        for (JDBCValueClassMetaData valueClass : valueClasses) {
            JDBCTypeComplex type = this.createTypeComplex(valueClass, valueClassesByType);
            this.complexTypes.put(valueClass.getJavaType(), type);
        }
        for (JDBCMappingMetaData mapping : typeMapping.getMappings()) {
            String sqlType = mapping.getSqlType();
            int jdbcType = mapping.getJdbcType();
            Class javaType = this.loadClass(mapping.getJavaType());
            boolean notNull = javaType.isPrimitive();
            boolean autoIncrement = false;
            JDBCParameterSetter paramSetter = mapping.getParamSetter() != null ? (JDBCParameterSetter)this.newInstance(mapping.getParamSetter()) : JDBCUtil.getParameterSetter(jdbcType, javaType);
            JDBCResultSetReader resultReader = mapping.getResultReader() != null ? (JDBCResultSetReader)this.newInstance(mapping.getResultReader()) : JDBCUtil.getResultSetReader(jdbcType, javaType);
            JDBCTypeSimple type = new JDBCTypeSimple(null, javaType, jdbcType, sqlType, notNull, autoIncrement, null, paramSetter, resultReader);
            this.mappedSimpleTypes.put(javaType, type);
        }
    }

    public JDBCType getJDBCType(Class javaType) {
        if (this.complexTypes.containsKey(javaType)) {
            return (JDBCTypeComplex)this.complexTypes.get(javaType);
        }
        JDBCTypeSimple type = (JDBCTypeSimple)this.mappedSimpleTypes.get(javaType);
        if (type == null) {
            JDBCResultSetReader resultReader;
            JDBCParameterSetter paramSetter;
            JDBCUserTypeMappingMetaData userTypeMapping = (JDBCUserTypeMappingMetaData)this.userTypeMappings.get(javaType.getName());
            Mapper mapper = null;
            if (userTypeMapping != null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    javaType = cl.loadClass(userTypeMapping.getMappedType());
                }
                catch (ClassNotFoundException e) {
                    throw CmpMessages.MESSAGES.failedToLoadMappedType(userTypeMapping.getMappedType(), e);
                }
                try {
                    mapper = (Mapper)this.newInstance(userTypeMapping.getMapper());
                }
                catch (Throwable t) {
                    throw CmpMessages.MESSAGES.failedToLoadMapperInstance(userTypeMapping.getMapper(), t);
                }
            }
            JDBCMappingMetaData typeMappingMD = this.typeMapping.getTypeMappingMetaData(javaType);
            String sqlType = typeMappingMD.getSqlType();
            int jdbcType = typeMappingMD.getJdbcType();
            boolean notNull = javaType.isPrimitive();
            boolean autoIncrement = false;
            if (typeMappingMD.getParamSetter() != null) {
                try {
                    paramSetter = (JDBCParameterSetter)this.newInstance(typeMappingMD.getParamSetter());
                }
                catch (Throwable e) {
                    throw CmpMessages.MESSAGES.failedToCreateParamSetter(typeMappingMD.getParamSetter(), e);
                }
            } else {
                paramSetter = JDBCUtil.getParameterSetter(jdbcType, javaType);
            }
            if (typeMappingMD.getResultReader() != null) {
                try {
                    resultReader = (JDBCResultSetReader)this.newInstance(typeMappingMD.getResultReader());
                }
                catch (Throwable e) {
                    throw CmpMessages.MESSAGES.failedToCreateResultReader(typeMappingMD.getResultReader(), e);
                }
            } else {
                resultReader = JDBCUtil.getResultSetReader(jdbcType, javaType);
            }
            type = new JDBCTypeSimple(null, javaType, jdbcType, sqlType, notNull, autoIncrement, mapper, paramSetter, resultReader);
        }
        return type;
    }

    public JDBCType getJDBCType(JDBCCMPFieldMetaData cmpField) {
        Class<?> fieldType = cmpField.getFieldType();
        JDBCType fieldJDBCType = this.complexTypes.containsKey(fieldType) ? this.createTypeComplex(cmpField) : this.createTypeSimple(cmpField);
        return fieldJDBCType;
    }

    public int getJDBCTypeForJavaType(Class clazz) {
        return this.typeMapping.getTypeMappingMetaData(clazz).getJdbcType();
    }

    public JDBCTypeMappingMetaData getTypeMapping() {
        return this.typeMapping;
    }

    private JDBCTypeComplex createTypeComplex(JDBCValueClassMetaData valueClass, HashMap valueClassesByType) {
        ArrayList propertyList = this.createComplexProperties(valueClass, valueClassesByType, new PropertyStack());
        JDBCTypeComplexProperty[] properties = new JDBCTypeComplexProperty[propertyList.size()];
        properties = propertyList.toArray(properties);
        return new JDBCTypeComplex(properties, valueClass.getJavaType());
    }

    private JDBCTypeSimple createTypeSimple(JDBCCMPFieldMetaData cmpField) {
        int jdbcType;
        String columnName = cmpField.getColumnName();
        Class<?> javaType = cmpField.getFieldType();
        JDBCMappingMetaData typeMappingMD = this.typeMapping.getTypeMappingMetaData(javaType);
        String paramSetter = typeMappingMD.getParamSetter();
        String resultReader = typeMappingMD.getResultReader();
        String sqlType = cmpField.getSQLType();
        if (sqlType != null) {
            jdbcType = cmpField.getJDBCType();
        } else {
            sqlType = typeMappingMD.getSqlType();
            jdbcType = typeMappingMD.getJdbcType();
        }
        boolean notNull = cmpField.isNotNull();
        boolean autoIncrement = cmpField.isAutoIncrement();
        Mapper mapper = null;
        JDBCUserTypeMappingMetaData userTypeMapping = (JDBCUserTypeMappingMetaData)this.userTypeMappings.get(javaType.getName());
        if (userTypeMapping != null) {
            String mappedTypeStr = userTypeMapping.getMappedType();
            try {
                ClassLoader contextClassLoader = TCLAction.UTIL.getContextClassLoader();
                Class<?> mapperClass = contextClassLoader.loadClass(userTypeMapping.getMapper());
                mapper = (Mapper)mapperClass.newInstance();
                javaType = contextClassLoader.loadClass(mappedTypeStr);
                if (cmpField.getSQLType() == null) {
                    JDBCMappingMetaData mappingMD = this.typeMapping.getTypeMappingMetaData(javaType);
                    sqlType = mappingMD.getSqlType();
                    jdbcType = mappingMD.getJdbcType();
                    paramSetter = mappingMD.getParamSetter();
                    resultReader = mappingMD.getResultReader();
                }
            }
            catch (ClassNotFoundException e) {
                throw CmpMessages.MESSAGES.couldNotCreateTypeMapper(userTypeMapping.getMapper(), e);
            }
            catch (Exception e) {
                throw CmpMessages.MESSAGES.couldNotCreateTypeMapper(userTypeMapping.getMapper(), e);
            }
        }
        JDBCParameterSetter paramSetterImpl = paramSetter == null ? JDBCUtil.getParameterSetter(jdbcType, javaType) : (JDBCParameterSetter)this.newInstance(paramSetter);
        JDBCResultSetReader resultReaderImpl = resultReader == null ? JDBCUtil.getResultSetReader(jdbcType, javaType) : (JDBCResultSetReader)this.newInstance(resultReader);
        return new JDBCTypeSimple(columnName, javaType, jdbcType, sqlType, notNull, autoIncrement, mapper, paramSetterImpl, resultReaderImpl);
    }

    private JDBCTypeComplex createTypeComplex(JDBCCMPFieldMetaData cmpField) {
        JDBCTypeComplex type = (JDBCTypeComplex)this.complexTypes.get(cmpField.getFieldType());
        JDBCTypeComplexProperty[] defaultProperties = type.getProperties();
        HashMap<String, JDBCCMPFieldPropertyMetaData> overrides = new HashMap<String, JDBCCMPFieldPropertyMetaData>();
        for (int i = 0; i < cmpField.getPropertyOverrides().size(); ++i) {
            JDBCCMPFieldPropertyMetaData p = cmpField.getPropertyOverrides().get(i);
            overrides.put(p.getPropertyName(), p);
        }
        JDBCTypeComplexProperty[] finalProperties = new JDBCTypeComplexProperty[defaultProperties.length];
        for (int i = 0; i < defaultProperties.length; ++i) {
            int jdbcType;
            String sqlType;
            JDBCCMPFieldPropertyMetaData override = (JDBCCMPFieldPropertyMetaData)overrides.remove(defaultProperties[i].getPropertyName());
            if (override == null) {
                finalProperties[i] = defaultProperties[i];
                finalProperties[i] = new JDBCTypeComplexProperty(defaultProperties[i], cmpField.getColumnName() + "_" + defaultProperties[i].getColumnName(), defaultProperties[i].getJDBCType(), defaultProperties[i].getSQLType(), cmpField.isNotNull() || defaultProperties[i].isNotNull());
                continue;
            }
            String columnName = override.getColumnName();
            if (columnName == null) {
                columnName = cmpField.getColumnName() + "_" + defaultProperties[i].getColumnName();
            }
            if ((sqlType = override.getSQLType()) != null) {
                jdbcType = override.getJDBCType();
            } else {
                sqlType = defaultProperties[i].getSQLType();
                jdbcType = defaultProperties[i].getJDBCType();
            }
            boolean notNull = cmpField.isNotNull() || override.isNotNull() || defaultProperties[i].isNotNull();
            finalProperties[i] = new JDBCTypeComplexProperty(defaultProperties[i], columnName, jdbcType, sqlType, notNull);
        }
        if (overrides.size() > 0) {
            String propertyName = (String)overrides.keySet().iterator().next();
            throw CmpMessages.MESSAGES.invalidPropertyValue(propertyName, cmpField.getFieldName(), cmpField.getFieldType().getName());
        }
        return new JDBCTypeComplex(finalProperties, cmpField.getFieldType());
    }

    private ArrayList createComplexProperties(JDBCValueClassMetaData valueClass, HashMap valueClassesByType, PropertyStack propertyStack) {
        ArrayList properties = new ArrayList();
        List<JDBCValuePropertyMetaData> valueClassProperties = valueClass.getProperties();
        for (int i = 0; i < valueClassProperties.size(); ++i) {
            JDBCValuePropertyMetaData propertyMetaData = valueClassProperties.get(i);
            properties.addAll(this.createComplexProperties(propertyMetaData, valueClassesByType, propertyStack));
        }
        return properties;
    }

    private ArrayList createComplexProperties(JDBCValuePropertyMetaData propertyMetaData, HashMap valueClassesByType, PropertyStack propertyStack) {
        propertyStack.pushPropertyMetaData(propertyMetaData);
        ArrayList<JDBCTypeComplexProperty> properties = new ArrayList<JDBCTypeComplexProperty>();
        Class<?> javaType = propertyMetaData.getPropertyType();
        if (!valueClassesByType.containsKey(javaType)) {
            int jdbcType;
            String propertyName = propertyStack.getPropertyName();
            String columnName = propertyStack.getColumnName();
            String sqlType = propertyMetaData.getSqlType();
            if (sqlType != null) {
                jdbcType = propertyMetaData.getJDBCType();
            } else {
                JDBCMappingMetaData typeMappingMD = this.typeMapping.getTypeMappingMetaData(javaType);
                sqlType = typeMappingMD.getSqlType();
                jdbcType = typeMappingMD.getJdbcType();
            }
            boolean notNull = propertyStack.isNotNull();
            Method[] getters = propertyStack.getGetters();
            Method[] setters = propertyStack.getSetters();
            properties.add(new JDBCTypeComplexProperty(propertyName, columnName, javaType, jdbcType, sqlType, notNull, getters, setters));
        } else {
            JDBCValueClassMetaData valueClass = (JDBCValueClassMetaData)valueClassesByType.get(javaType);
            properties.addAll(this.createComplexProperties(valueClass, valueClassesByType, propertyStack));
        }
        propertyStack.popPropertyMetaData();
        return properties;
    }

    private Object newInstance(String className) {
        Class clazz = this.loadClass(className);
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.couldNotInstantiateClass(className, e);
        }
    }

    private Class loadClass(String className) {
        try {
            ClassLoader contextClassLoader = TCLAction.UTIL.getContextClassLoader();
            return contextClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw CmpMessages.MESSAGES.couldNotLoadClass(className, e);
        }
    }

    private static final class PropertyStack {
        final ArrayList properties = new ArrayList();
        final ArrayList propertyNames = new ArrayList();
        final ArrayList columnNames = new ArrayList();
        final ArrayList notNulls = new ArrayList();
        final ArrayList getters = new ArrayList();
        final ArrayList setters = new ArrayList();

        public void pushPropertyMetaData(JDBCValuePropertyMetaData propertyMetaData) {
            this.propertyNames.add(propertyMetaData.getPropertyName());
            this.columnNames.add(propertyMetaData.getColumnName());
            this.notNulls.add(new Boolean(propertyMetaData.isNotNull()));
            this.getters.add(propertyMetaData.getGetter());
            this.setters.add(propertyMetaData.getSetter());
            if (this.properties.contains(propertyMetaData)) {
                throw CmpMessages.MESSAGES.circularReferenceForProperty(this.getPropertyName());
            }
            this.properties.add(propertyMetaData);
        }

        public void popPropertyMetaData() {
            this.propertyNames.remove(this.propertyNames.size() - 1);
            this.columnNames.remove(this.columnNames.size() - 1);
            this.notNulls.remove(this.notNulls.size() - 1);
            this.getters.remove(this.getters.size() - 1);
            this.setters.remove(this.setters.size() - 1);
            this.properties.remove(this.properties.size() - 1);
        }

        public String getPropertyName() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.propertyNames.size(); ++i) {
                if (i > 0) {
                    buf.append(".");
                }
                buf.append((String)this.propertyNames.get(i));
            }
            return buf.toString();
        }

        public String getColumnName() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.columnNames.size(); ++i) {
                if (i > 0) {
                    buf.append("_");
                }
                buf.append((String)this.columnNames.get(i));
            }
            return buf.toString();
        }

        public boolean isNotNull() {
            for (int i = 0; i < this.notNulls.size(); ++i) {
                if (!((Boolean)this.notNulls.get(i)).booleanValue()) continue;
                return true;
            }
            return false;
        }

        public Method[] getGetters() {
            return this.getters.toArray(new Method[this.getters.size()]);
        }

        public Method[] getSetters() {
            return this.setters.toArray(new Method[this.setters.size()]);
        }
    }
}

