/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.keygenerator;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactory;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;

public class KeyGeneratorFactoryRegistry
implements Service<KeyGeneratorFactoryRegistry> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"cmp", "keygen", "registry"});
    private final Map<String, KeyGeneratorFactory> factories = new HashMap<String, KeyGeneratorFactory>();

    public synchronized void start(StartContext context) throws StartException {
    }

    public synchronized void stop(StopContext context) {
        this.factories.clear();
    }

    public synchronized KeyGeneratorFactoryRegistry getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    void addKeyGeneratorFactory(String name, KeyGeneratorFactory factory) {
        this.factories.put(name, factory);
    }

    void removeKeyGeneratorFactory(String name) {
        this.factories.remove(name);
    }

    public KeyGeneratorFactory getFactory(String name) {
        return this.factories.get(name);
    }

    public static Injector<KeyGeneratorFactoryRegistry> getRegistryInjector(final String name, final Value<KeyGeneratorFactory> factory) {
        return new Injector<KeyGeneratorFactoryRegistry>(){
            private KeyGeneratorFactoryRegistry registry;

            public synchronized void inject(KeyGeneratorFactoryRegistry value) throws InjectionException {
                this.registry = value;
                this.registry.addKeyGeneratorFactory(name, (KeyGeneratorFactory)factory.getValue());
            }

            public synchronized void uninject() {
                this.registry.removeKeyGeneratorFactory(name);
            }
        };
    }
}

