/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.service;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ApplicationClientDeploymentService
implements Service<ApplicationClientDeploymentService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"appClientDeploymentService"});
    private final File path;
    private ModelControllerClient controllerClient;
    private final InjectedValue<ModelController> controllerValue = new InjectedValue();
    private final CountDownLatch deploymentCompleteLatch = new CountDownLatch(1);

    public ApplicationClientDeploymentService(File path) {
        this.path = path;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.controllerClient = ((ModelController)this.controllerValue.getValue()).createClient((Executor)Executors.newSingleThreadExecutor());
        DeployTask task = new DeployTask();
        Thread thread = new Thread(new DeploymentTask(new OperationBuilder(task.getUpdate()).build()));
        thread.start();
    }

    public synchronized void stop(StopContext context) {
    }

    public ApplicationClientDeploymentService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ModelController> getControllerValue() {
        return this.controllerValue;
    }

    public CountDownLatch getDeploymentCompleteLatch() {
        return this.deploymentCompleteLatch;
    }

    private class DeploymentTask
    implements Runnable {
        private final Operation deploymentOp;

        private DeploymentTask(Operation deploymentOp) {
            this.deploymentOp = deploymentOp;
        }

        @Override
        public void run() {
            try {
                ModelNode result = ApplicationClientDeploymentService.this.controllerClient.execute(this.deploymentOp);
                if (!"success".equals(result.get("outcome").asString())) {
                    System.exit(1);
                }
                ApplicationClientDeploymentService.this.deploymentCompleteLatch.countDown();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class DeployTask {
        private DeployTask() {
        }

        protected ModelNode getUpdate() {
            ModelNode address = new ModelNode().add("deployment", ApplicationClientDeploymentService.this.path.getName());
            ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)address);
            addOp.get("content").set(this.createContent());
            addOp.get("persistent").set(false);
            ModelNode deployOp = Util.getEmptyOperation((String)"deploy", (ModelNode)address);
            return this.getCompositeUpdate(addOp, deployOp);
        }

        protected ModelNode createContent() {
            ModelNode content = new ModelNode();
            ModelNode contentItem = content.get(0);
            contentItem.get("path").set(ApplicationClientDeploymentService.this.path.getAbsolutePath());
            contentItem.get("archive").set(!ApplicationClientDeploymentService.this.path.isDirectory());
            return content;
        }

        private ModelNode getCompositeUpdate(ModelNode ... updates) {
            ModelNode op = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
            ModelNode steps = op.get("steps");
            for (ModelNode update : updates) {
                steps.add(update);
            }
            return op;
        }
    }
}

