/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.resource.spi.ConnectionManager;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.referenceable.ConnectionFactoryObjectFactory;
import org.hornetq.jms.referenceable.SerializableObjectRefAddr;
import org.hornetq.ra.HornetQRAConnectionFactory;
import org.hornetq.ra.HornetQRAConnectionManager;
import org.hornetq.ra.HornetQRAManagedConnectionFactory;
import org.hornetq.ra.HornetQRASessionFactoryImpl;

public class HornetQRAConnectionFactoryImpl
implements HornetQRAConnectionFactory {
    static final long serialVersionUID = 7981708919479859360L;
    private static final Logger log = Logger.getLogger(HornetQRAConnectionFactoryImpl.class);
    private static boolean trace = log.isTraceEnabled();
    private final HornetQRAManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;

    public HornetQRAConnectionFactoryImpl(HornetQRAManagedConnectionFactory mcf, ConnectionManager cm) {
        if (trace) {
            log.trace((Object)("constructor(" + mcf + ", " + cm + ")"));
        }
        this.mcf = mcf;
        if (cm == null) {
            this.cm = new HornetQRAConnectionManager();
            if (trace) {
                log.trace((Object)("Created new ConnectionManager=" + this.cm));
            }
        } else {
            this.cm = cm;
        }
        if (trace) {
            log.trace((Object)("Using ManagedConnectionFactory=" + mcf + ", ConnectionManager=" + cm));
        }
    }

    public void setReference(Reference reference) {
        if (trace) {
            log.trace((Object)("setReference(" + reference + ")"));
        }
        this.reference = reference;
    }

    public Reference getReference() {
        if (trace) {
            log.trace((Object)"getReference()");
        }
        if (this.reference == null) {
            try {
                this.reference = new Reference(this.getClass().getCanonicalName(), (RefAddr)new SerializableObjectRefAddr("HornetQ-CF", (Object)this), ConnectionFactoryObjectFactory.class.getCanonicalName(), null);
            }
            catch (NamingException e) {
                log.error((Object)"Error while giving object Reference.", (Throwable)e);
            }
        }
        return this.reference;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createQueueConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 1);
        if (trace) {
            log.trace((Object)("Created queue connection: " + s));
        }
        return s;
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createQueueConnection(" + userName + ", ****)"));
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 1);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created queue connection: " + s));
        }
        return s;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createTopicConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 2);
        if (trace) {
            log.trace((Object)("Created topic connection: " + s));
        }
        return s;
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createTopicConnection(" + userName + ", ****)"));
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 2);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created topic connection: " + s));
        }
        return s;
    }

    public Connection createConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 0);
        if (trace) {
            log.trace((Object)("Created connection: " + s));
        }
        return s;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createConnection(" + userName + ", ****)"));
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 0);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created connection: " + s));
        }
        return s;
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createXAQueueConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 4);
        if (trace) {
            log.trace((Object)("Created queue connection: " + s));
        }
        return s;
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createXAQueueConnection(" + userName + ", ****)"));
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 4);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created queue connection: " + s));
        }
        return s;
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createXATopicConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 5);
        if (trace) {
            log.trace((Object)("Created topic connection: " + s));
        }
        return s;
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createXATopicConnection(" + userName + ", ****)"));
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 5);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created topic connection: " + s));
        }
        return s;
    }

    public XAConnection createXAConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createXAConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 3);
        if (trace) {
            log.trace((Object)("Created connection: " + s));
        }
        return s;
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createXAConnection(" + userName + ", ****)"));
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 3);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created connection: " + s));
        }
        return s;
    }
}

