/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import org.jboss.as.controller.client.ControllerClientMessages;
import org.jboss.as.controller.client.helpers.domain.DeploymentAction;
import org.jboss.as.controller.client.helpers.domain.RollbackCancelledException;

public class ControllerClientMessages_$bundle
implements Serializable,
ControllerClientMessages {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "JBAS";
    public static final ControllerClientMessages_$bundle INSTANCE = new ControllerClientMessages_$bundle();
    private static final String cannotDeriveDeploymentName = "Cannot derive a deployment name from %s -- use an overloaded method variant that takes a 'name' parameter";
    private static final String incompleteDeploymentReplace = "Only one version of deployment with a given unique name can exist in the domain. The deployment plan specified that a new version of deployment %s replace an existing deployment with the same unique name, but did not apply the replacement to all server groups. Missing server groups were: %s";
    private static final String operationsNotAllowed = "%s operations are not allowed after content and deployment modifications";
    private static final String rollbackCancelled = "Rollback was cancelled";
    private static final String unknownActionType = "Unknown action type %s";
    private static final String noFailureDetails = "No failure details provided";
    private static final String cannotUseDeploymentPlan = "Cannot use a DeploymentPlan not created by this manager";
    private static final String cannotAddDeploymentActionsAfterStart = "Cannot add deployment actions after starting creation of a rollout plan";
    private static final String failed = "failed";
    private static final String cannotConvert = "Cannot convert %s to %s";
    private static final String gracefulShutdownAlreadyConfigured = "Graceful shutdown already configured with a timeout of %d ms";
    private static final String invalidUri = "%s is not a valid URI";
    private static final String invalidValue4 = "Illegal %s value %d -- must be greater than %d and less than %d";
    private static final String rollbackTimedOut = "Rollback timed out";
    private static final String invalidPrecedingAction = "Preceding action was not a %s";
    private static final String invalidValue3 = "Illegal %s value %d -- must be greater than %d";
    private static final String serverDeploymentAlreadyExists = "Deployment with name %s already present in the server";
    private static final String channelClosed = "Channel closed";
    private static final String noActiveRequest = "No active request found for %d";
    private static final String rollbackRolledBack = "Rollback was itself rolled back";
    private static final String maxDisplayUnitLength = "Screen real estate is expensive; displayUnits must be 5 characters or less";
    private static final String globalRollbackNotCompatible = "Global rollback is not compatible with a server restart";
    private static final String controllerClientNotClosed = "Allocation stack trace:";
    private static final String cannotAddDeploymentAction = "Cannot add deployment actions after starting creation of a rollout plan";
    private static final String objectIsClosed = "%s is closed";
    private static final String nullVar = "%s is null";
    private static final String notConfigured = "No %s is configured";
    private static final String domainDeploymentAlreadyExists = "Deployment with name %s already present in the domain";
    private static final String operationOutcome = "Operation outcome is %s";
    private static final String invalidActionType = "Invalid action type %s";

    protected ControllerClientMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final IllegalArgumentException cannotDeriveDeploymentName(URL url) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("JBAS010623: " + this.cannotDeriveDeploymentName$str(), url));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeriveDeploymentName$str() {
        return cannotDeriveDeploymentName;
    }

    @Override
    public final String incompleteDeploymentReplace(String deploymentName, String missingGroups) {
        String result = String.format("JBAS010630: " + this.incompleteDeploymentReplace$str(), deploymentName, missingGroups);
        return result;
    }

    protected String incompleteDeploymentReplace$str() {
        return incompleteDeploymentReplace;
    }

    @Override
    public final IllegalStateException operationsNotAllowed(String name) {
        IllegalStateException result = new IllegalStateException(String.format("JBAS010643: " + this.operationsNotAllowed$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String operationsNotAllowed$str() {
        return operationsNotAllowed;
    }

    @Override
    public final RollbackCancelledException rollbackCancelled() {
        RollbackCancelledException result = new RollbackCancelledException(String.format("JBAS010644: " + this.rollbackCancelled$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rollbackCancelled$str() {
        return rollbackCancelled;
    }

    @Override
    public final IllegalStateException unknownActionType(Object type) {
        IllegalStateException result = new IllegalStateException(String.format("JBAS010648: " + this.unknownActionType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownActionType$str() {
        return unknownActionType;
    }

    @Override
    public final String noFailureDetails() {
        String result = String.format("JBAS010638: " + this.noFailureDetails$str(), new Object[0]);
        return result;
    }

    protected String noFailureDetails$str() {
        return noFailureDetails;
    }

    @Override
    public final IllegalArgumentException cannotUseDeploymentPlan() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("JBAS010624: " + this.cannotUseDeploymentPlan$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotUseDeploymentPlan$str() {
        return cannotUseDeploymentPlan;
    }

    @Override
    public final IllegalStateException cannotAddDeploymentActionsAfterStart() {
        IllegalStateException result = new IllegalStateException(String.format("JBAS010621: " + this.cannotAddDeploymentActionsAfterStart$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAddDeploymentActionsAfterStart$str() {
        return "Cannot add deployment actions after starting creation of a rollout plan";
    }

    @Override
    public final String failed() {
        String result = String.format("JBAS010627: " + this.failed$str(), new Object[0]);
        return result;
    }

    protected String failed$str() {
        return failed;
    }

    @Override
    public final String cannotConvert(String first, String second) {
        String result = String.format("JBAS010622: " + this.cannotConvert$str(), first, second);
        return result;
    }

    protected String cannotConvert$str() {
        return cannotConvert;
    }

    @Override
    public final IllegalStateException gracefulShutdownAlreadyConfigured(long timeout) {
        IllegalStateException result = new IllegalStateException(String.format("JBAS010629: " + this.gracefulShutdownAlreadyConfigured$str(), timeout));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String gracefulShutdownAlreadyConfigured$str() {
        return gracefulShutdownAlreadyConfigured;
    }

    @Override
    public final IllegalArgumentException invalidUri(Throwable cause, URL url) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("JBAS010633: " + this.invalidUri$str(), url), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidUri$str() {
        return invalidUri;
    }

    @Override
    public final IllegalArgumentException invalidValue(String name, int value, int minValue, int maxValue) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("JBAS010635: " + this.invalidValue4$str(), name, value, minValue, maxValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidValue4$str() {
        return invalidValue4;
    }

    @Override
    public final RollbackCancelledException rollbackTimedOut() {
        RollbackCancelledException result = new RollbackCancelledException(String.format("JBAS010646: " + this.rollbackTimedOut$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rollbackTimedOut$str() {
        return rollbackTimedOut;
    }

    @Override
    public final IllegalStateException invalidPrecedingAction(Object type) {
        IllegalStateException result = new IllegalStateException(String.format("JBAS010632: " + this.invalidPrecedingAction$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPrecedingAction$str() {
        return invalidPrecedingAction;
    }

    @Override
    public final IllegalArgumentException invalidValue(String name, int value, int minValue) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("JBAS010634: " + this.invalidValue3$str(), name, value, minValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidValue3$str() {
        return invalidValue3;
    }

    @Override
    public final String serverDeploymentAlreadyExists(String name) {
        String result = String.format("JBAS010647: " + this.serverDeploymentAlreadyExists$str(), name);
        return result;
    }

    protected String serverDeploymentAlreadyExists$str() {
        return serverDeploymentAlreadyExists;
    }

    @Override
    public final IOException channelClosed(IOException cause) {
        IOException result = new IOException(String.format("JBAS010625: " + this.channelClosed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String channelClosed$str() {
        return channelClosed;
    }

    @Override
    public final IOException noActiveRequest(int batchId) {
        IOException result = new IOException(String.format("JBAS010637: " + this.noActiveRequest$str(), batchId));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noActiveRequest$str() {
        return noActiveRequest;
    }

    @Override
    public final RollbackCancelledException rollbackRolledBack() {
        RollbackCancelledException result = new RollbackCancelledException(String.format("JBAS010645: " + this.rollbackRolledBack$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rollbackRolledBack$str() {
        return rollbackRolledBack;
    }

    @Override
    public final RuntimeException maxDisplayUnitLength() {
        RuntimeException result = new RuntimeException(String.format("JBAS010636: " + this.maxDisplayUnitLength$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String maxDisplayUnitLength$str() {
        return maxDisplayUnitLength;
    }

    @Override
    public final IllegalStateException globalRollbackNotCompatible() {
        IllegalStateException result = new IllegalStateException(String.format("JBAS010628: " + this.globalRollbackNotCompatible$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String globalRollbackNotCompatible$str() {
        return globalRollbackNotCompatible;
    }

    @Override
    public final ControllerClientMessages.LeakDescription controllerClientNotClosed() {
        ControllerClientMessages.LeakDescription result = new ControllerClientMessages.LeakDescription(String.format("JBAS010649: " + this.controllerClientNotClosed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String controllerClientNotClosed$str() {
        return controllerClientNotClosed;
    }

    @Override
    public final IllegalStateException cannotAddDeploymentAction() {
        IllegalStateException result = new IllegalStateException(String.format("JBAS010620: " + this.cannotAddDeploymentAction$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAddDeploymentAction$str() {
        return "Cannot add deployment actions after starting creation of a rollout plan";
    }

    @Override
    public final IllegalStateException objectIsClosed(String name) {
        IllegalStateException result = new IllegalStateException(String.format("JBAS010641: " + this.objectIsClosed$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String objectIsClosed$str() {
        return objectIsClosed;
    }

    @Override
    public final IllegalArgumentException nullVar(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("JBAS010640: " + this.nullVar$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullVar$str() {
        return nullVar;
    }

    @Override
    public final IllegalStateException notConfigured(String name) {
        IllegalStateException result = new IllegalStateException(String.format("JBAS010639: " + this.notConfigured$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notConfigured$str() {
        return notConfigured;
    }

    @Override
    public final String domainDeploymentAlreadyExists(String name) {
        String result = String.format("JBAS010626: " + this.domainDeploymentAlreadyExists$str(), name);
        return result;
    }

    protected String domainDeploymentAlreadyExists$str() {
        return domainDeploymentAlreadyExists;
    }

    @Override
    public final RuntimeException operationOutcome(String outcome) {
        RuntimeException result = new RuntimeException(String.format("JBAS010642: " + this.operationOutcome$str(), outcome));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String operationOutcome$str() {
        return operationOutcome;
    }

    @Override
    public final IllegalStateException invalidActionType(DeploymentAction.Type type) {
        IllegalStateException result = new IllegalStateException(String.format("JBAS010631: " + this.invalidActionType$str(), new Object[]{type}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidActionType$str() {
        return invalidActionType;
    }
}

