/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.filters;

import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SubstituteFilter
implements Filter {
    private final Pattern pattern;
    private final String replacement;
    private final boolean replaceAll;

    public SubstituteFilter(Pattern pattern, String replacement, boolean replaceAll) {
        this.pattern = pattern;
        this.replacement = replacement;
        this.replaceAll = replaceAll;
    }

    public SubstituteFilter(String patternString, String replacement, boolean replaceAll) {
        this(Pattern.compile(patternString), replacement, replaceAll);
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        Matcher matcher = this.pattern.matcher(record.getMessage());
        if (this.replaceAll) {
            record.setMessage(matcher.replaceAll(this.replacement));
        } else {
            record.setMessage(matcher.replaceFirst(this.replacement));
        }
        return true;
    }
}

