/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.client.CurrentEjbClientConnection;
import org.jboss.naming.remote.client.RemoteContextFactory;
import org.jboss.naming.remote.client.RemoteNamingStore;
import org.jboss.naming.remote.protocol.IoFutureHelper;
import org.jboss.naming.remote.protocol.NamingIOException;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class HaRemoteNamingStore
implements RemoteNamingStore {
    private static final Logger logger = Logger.getLogger(HaRemoteNamingStore.class);
    private final Endpoint clientEndpoint;
    private final List<URI> connectionURIs;
    private final OptionMap connectOptions;
    private final CallbackHandler callbackHandler;
    private final long connectionTimeout;
    private final OptionMap channelCreationOptions;
    private final long channelCreationTimeoutInMillis;
    private volatile boolean closed = false;
    private volatile int nextServer;
    private volatile RemoteNamingStore currentNamingStore;
    private final Set<CurrentEjbClientConnection> currentEjbClientContexts = new HashSet<CurrentEjbClientConnection>();
    private Connection connection;

    public HaRemoteNamingStore(long channelCreationTimeoutInMillis, OptionMap channelCreationOptions, long connectionTimeout, CallbackHandler callbackHandler, OptionMap connectOptions, List<URI> connectionURIs, Endpoint clientEndpoint, boolean randomServer) {
        if (connectionURIs.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a HA remote naming store without any servers to connect to");
        }
        this.channelCreationTimeoutInMillis = channelCreationTimeoutInMillis;
        this.channelCreationOptions = channelCreationOptions;
        this.connectionTimeout = connectionTimeout;
        this.callbackHandler = callbackHandler;
        this.connectOptions = connectOptions;
        this.connectionURIs = connectionURIs;
        this.clientEndpoint = clientEndpoint;
        this.nextServer = randomServer ? new Random().nextInt(connectionURIs.size()) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T namingOperation(Operation<T> operation) throws NamingException {
        if (this.closed) {
            throw new NamingException("NamingStore has been closed");
        }
        RemoteNamingStore namingStore = this.namingStore();
        try {
            return operation.operation(namingStore);
        }
        catch (NamingIOException e) {
            HaRemoteNamingStore haRemoteNamingStore = this;
            synchronized (haRemoteNamingStore) {
                namingStore = this.failOverSequence(namingStore);
            }
            return operation.operation(namingStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteNamingStore namingStore() throws NamingException {
        RemoteNamingStore namingStore = this.currentNamingStore;
        if (namingStore == null) {
            HaRemoteNamingStore haRemoteNamingStore = this;
            synchronized (haRemoteNamingStore) {
                if (this.currentNamingStore == null) {
                    return this.failOverSequence(null);
                }
                return this.currentNamingStore;
            }
        }
        return namingStore;
    }

    private RemoteNamingStore failOverSequence(RemoteNamingStore attempted) throws NamingException {
        int startingNext;
        assert (Thread.holdsLock(this));
        RemoteNamingStore currentNamingStore = this.currentNamingStore;
        if (attempted != null && attempted != currentNamingStore) {
            return currentNamingStore;
        }
        if (currentNamingStore != null) {
            try {
                currentNamingStore.close();
                this.connection.close();
            }
            catch (Exception e) {
                logger.debug((Object)"Failed to close existing naming store on failover", e);
            }
        }
        int currentServer = startingNext = this.nextServer();
        RemoteNamingStore store = null;
        while (true) {
            URI connectionUri = this.connectionURIs.get(currentServer);
            Connection connection = null;
            try {
                IoFuture<Connection> futureConnection = this.clientEndpoint.connect(connectionUri, this.connectOptions, this.callbackHandler);
                connection = IoFutureHelper.get(futureConnection, this.connectionTimeout, TimeUnit.MILLISECONDS);
                IoFuture<Channel> futureChannel = connection.openChannel("naming", this.channelCreationOptions);
                Channel channel = IoFutureHelper.get(futureChannel, this.channelCreationTimeoutInMillis, TimeUnit.MILLISECONDS);
                store = RemoteContextFactory.createVersionedStore(channel);
                this.connection = connection;
            }
            catch (Exception e) {
                logger.debug((Object)("Failed to connect to server " + connectionUri), e);
                currentServer = this.nextServer();
                if (connection == null) continue;
                try {
                    connection.close();
                    continue;
                }
                catch (IOException e1) {
                    logger.debug((Object)("Failed to close connection " + connectionUri), e);
                }
                if (currentServer != startingNext) continue;
            }
            break;
        }
        if (store == null) {
            throw new NamingException("Failed to connect to any server. Servers tried: " + this.connectionURIs);
        }
        this.currentNamingStore = store;
        for (CurrentEjbClientConnection currentEjbClientContext : this.currentEjbClientContexts) {
            currentEjbClientContext.setConnection(this.connection);
        }
        return store;
    }

    private int nextServer() {
        assert (Thread.holdsLock(this));
        int next = this.nextServer;
        int newValue = next + 1;
        this.nextServer = newValue == this.connectionURIs.size() ? 0 : newValue;
        return next;
    }

    @Override
    public Object lookup(final Name name) throws NamingException {
        return this.namingOperation(new Operation<Object>(){

            @Override
            public Object operation(RemoteNamingStore store) throws NamingException {
                return store.lookup(name);
            }
        });
    }

    @Override
    public void bind(final Name name, final Object object) throws NamingException {
        this.namingOperation(new Operation<Void>(){

            @Override
            public Void operation(RemoteNamingStore store) throws NamingException {
                store.bind(name, object);
                return null;
            }
        });
    }

    @Override
    public void rebind(final Name name, final Object object) throws NamingException {
        this.namingOperation(new Operation<Void>(){

            @Override
            public Void operation(RemoteNamingStore store) throws NamingException {
                store.rebind(name, object);
                return null;
            }
        });
    }

    @Override
    public void rename(final Name name, final Name object) throws NamingException {
        this.namingOperation(new Operation<Void>(){

            @Override
            public Void operation(RemoteNamingStore store) throws NamingException {
                store.rename(name, object);
                return null;
            }
        });
    }

    @Override
    public List<NameClassPair> list(final Name name) throws NamingException {
        return this.namingOperation(new Operation<List<NameClassPair>>(){

            @Override
            public List<NameClassPair> operation(RemoteNamingStore store) throws NamingException {
                return store.list(name);
            }
        });
    }

    @Override
    public List<Binding> listBindings(final Name name) throws NamingException {
        return this.namingOperation(new Operation<List<Binding>>(){

            @Override
            public List<Binding> operation(RemoteNamingStore store) throws NamingException {
                return store.listBindings(name);
            }
        });
    }

    @Override
    public void unbind(final Name name) throws NamingException {
        this.namingOperation(new Operation<Void>(){

            @Override
            public Void operation(RemoteNamingStore store) throws NamingException {
                store.unbind(name);
                return null;
            }
        });
    }

    @Override
    public Context createSubcontext(final Name name) throws NamingException {
        return this.namingOperation(new Operation<Context>(){

            @Override
            public Context operation(RemoteNamingStore store) throws NamingException {
                return store.createSubcontext(name);
            }
        });
    }

    @Override
    public void destroySubcontext(final Name name) throws NamingException {
        this.namingOperation(new Operation<Void>(){

            @Override
            public Void operation(RemoteNamingStore store) throws NamingException {
                store.destroySubcontext(name);
                return null;
            }
        });
    }

    @Override
    public Object lookupLink(final Name name) throws NamingException {
        return this.namingOperation(new Operation<Object>(){

            @Override
            public Object operation(RemoteNamingStore store) throws NamingException {
                return store.lookupLink(name);
            }
        });
    }

    @Override
    public synchronized void close() throws NamingException {
        this.closed = true;
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            NamingException exception = new NamingException("Failed to close connection");
            exception.initCause(e);
            throw exception;
        }
    }

    @Override
    public synchronized void addEjbContext(CurrentEjbClientConnection connection) {
        if (this.connection != null) {
            connection.setConnection(this.connection);
        }
        this.currentEjbClientContexts.add(connection);
    }

    @Override
    public synchronized void removeEjbContext(CurrentEjbClientConnection connection) {
        this.currentEjbClientContexts.remove(connection);
    }

    private static interface Operation<T> {
        public T operation(RemoteNamingStore var1) throws NamingException;
    }
}

