/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.client.HaRemoteNamingStore;
import org.jboss.naming.remote.client.RemoteContext;
import org.jboss.naming.remote.client.RemoteContextFactory;
import org.jboss.naming.remote.client.RemoteNamingStore;
import org.jboss.naming.remote.protocol.IoFutureHelper;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class NamingStoreCache {
    private static final Logger logger = Logger.getLogger(NamingStoreCache.class);
    private final ConcurrentMap<CacheKey, CacheEntry> cache = new ConcurrentHashMap<CacheKey, CacheEntry>();

    public synchronized RemoteNamingStore getRemoteNamingStore(Endpoint clientEndpoint, String connectionURL, OptionMap connectOptions, CallbackHandler callbackHandler, long connectionTimeout, OptionMap channelCreationOptions, long channelCreationTimeoutInMillis, List<RemoteContext.CloseTask> contextCloseTasks, boolean randomServer) throws IOException, NamingException, URISyntaxException {
        final CacheKey key = new CacheKey(clientEndpoint, callbackHandler.getClass(), connectOptions, connectionURL);
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(key);
        Connection connection = null;
        if (cacheEntry == null) {
            RemoteNamingStore store;
            if (connectionURL.contains(",")) {
                String[] urls = connectionURL.split(",");
                ArrayList<URI> connectionUris = new ArrayList<URI>(urls.length);
                for (String url : urls) {
                    connectionUris.add(new URI(url));
                }
                store = new HaRemoteNamingStore(channelCreationTimeoutInMillis, channelCreationOptions, connectionTimeout, callbackHandler, connectOptions, connectionUris, clientEndpoint, randomServer);
            } else {
                IoFuture<Connection> futureConnection = clientEndpoint.connect(new URI(connectionURL), connectOptions, callbackHandler);
                connection = IoFutureHelper.get(futureConnection, connectionTimeout, TimeUnit.MILLISECONDS);
                IoFuture<Channel> futureChannel = connection.openChannel("naming", channelCreationOptions);
                Channel channel = IoFutureHelper.get(futureChannel, channelCreationTimeoutInMillis, TimeUnit.MILLISECONDS);
                store = RemoteContextFactory.createVersionedStore(channel);
            }
            cacheEntry = new CacheEntry(connection, store);
            this.cache.put(key, cacheEntry);
        }
        contextCloseTasks.add(new RemoteContext.CloseTask(){

            @Override
            public void close(boolean isFinalize) {
                NamingStoreCache.this.release(key, isFinalize);
            }
        });
        cacheEntry.referenceCount.incrementAndGet();
        return cacheEntry.namingStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(CacheKey connectionHash, boolean async) {
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(connectionHash);
        if (cacheEntry.referenceCount.decrementAndGet() == 0) {
            try {
                cacheEntry.namingStore.close();
            }
            catch (NamingException e) {
                throw new RuntimeException("Failed to close naming store", e);
            }
            finally {
                block17: {
                    try {
                        if (cacheEntry.connection == null) break block17;
                        if (async) {
                            cacheEntry.connection.closeAsync();
                            break block17;
                        }
                        try {
                            cacheEntry.connection.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to close connection", e);
                        }
                    }
                    finally {
                        this.cache.remove(connectionHash);
                    }
                }
            }
        }
    }

    public synchronized void shutdown() {
        for (Map.Entry entry : this.cache.entrySet()) {
            NamingStoreCache.safeClose(((CacheEntry)entry.getValue()).connection);
        }
    }

    private static void safeClose(Closeable closable) {
        try {
            closable.close();
        }
        catch (Throwable t) {
            logger.debug((Object)"Failed to close connection ", t);
        }
    }

    private static final class CacheKey {
        final Endpoint endpoint;
        final String destination;
        final OptionMap connectOptions;
        final Class<?> callbackHandlerClass;

        private CacheKey(Endpoint endpoint, Class<?> callbackHandlerClass, OptionMap connectOptions, String destination) {
            this.endpoint = endpoint;
            this.callbackHandlerClass = callbackHandlerClass;
            this.connectOptions = connectOptions;
            this.destination = destination;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.callbackHandlerClass != null ? !this.callbackHandlerClass.equals(cacheKey.callbackHandlerClass) : cacheKey.callbackHandlerClass != null) {
                return false;
            }
            if (this.connectOptions != null ? !this.connectOptions.equals(cacheKey.connectOptions) : cacheKey.connectOptions != null) {
                return false;
            }
            if (this.destination != null ? !this.destination.equals(cacheKey.destination) : cacheKey.destination != null) {
                return false;
            }
            return !(this.endpoint != null ? !this.endpoint.equals(cacheKey.endpoint) : cacheKey.endpoint != null);
        }

        public int hashCode() {
            int result = this.endpoint != null ? this.endpoint.hashCode() : 0;
            result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
            result = 31 * result + (this.connectOptions != null ? this.connectOptions.hashCode() : 0);
            result = 31 * result + (this.callbackHandlerClass != null ? this.callbackHandlerClass.hashCode() : 0);
            return result;
        }
    }

    private class CacheEntry {
        private final AtomicInteger referenceCount = new AtomicInteger(0);
        private final Connection connection;
        private final RemoteNamingStore namingStore;

        private CacheEntry(Connection connection, RemoteNamingStore namingStore) {
            this.connection = connection;
            this.namingStore = namingStore;
        }
    }
}

