/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.InvalidClassException;
import java.io.SerializablePermission;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import org.jboss.marshalling.Creator;

public class ReflectiveCreator
implements Creator {
    private static final Permission CREATOR_PERM = new SerializablePermission("creator");

    public ReflectiveCreator() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATOR_PERM);
        }
    }

    protected <T> Constructor<T> getNewConstructor(final Class<T> clazz) {
        Constructor newConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<T>>(){

            @Override
            public Constructor<T> run() {
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return constructor;
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
        return newConstructor;
    }

    @Override
    public <T> T create(Class<T> clazz) throws InvalidClassException {
        Constructor<T> newConstructor = this.getNewConstructor(clazz);
        if (newConstructor == null) {
            throw new InvalidClassException(clazz.getName(), "No suitable constructor could be found");
        }
        Constructor<T> constructor = newConstructor;
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            InvalidClassException ice = new InvalidClassException(clazz.getName(), "Constructor threw an exception");
            ice.initCause(e);
            throw ice;
        }
        catch (IllegalAccessException e) {
            throw new InvalidClassException(clazz.getName(), "Illegal access exception occurred accessing the constructor: " + String.valueOf(e));
        }
        catch (InstantiationException e) {
            throw new InvalidClassException(clazz.getName(), "Instantiation exception: " + String.valueOf(e));
        }
    }
}

