/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.Locale;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class AbstractQueueControlHandler<T>
extends AbstractRuntimeOnlyHandler {
    public static final String LIST_MESSAGES = "list-messages";
    public static final String LIST_MESSAGES_AS_JSON = "list-messages-as-json";
    public static final String COUNT_MESSAGES = "count-messages";
    public static final String REMOVE_MESSAGE = "remove-message";
    public static final String REMOVE_MESSAGES = "remove-messages";
    public static final String EXPIRE_MESSAGES = "expire-messages";
    public static final String EXPIRE_MESSAGE = "expire-message";
    public static final String SEND_MESSAGE_TO_DEAD_LETTER_ADDRESS = "send-message-to-dead-letter-address";
    public static final String SEND_MESSAGES_TO_DEAD_LETTER_ADDRESS = "send-messages-to-dead-letter-address";
    public static final String CHANGE_MESSAGE_PRIORITY = "change-message-priority";
    public static final String CHANGE_MESSAGES_PRIORITY = "change-messages-priority";
    public static final String MOVE_MESSAGE = "move-message";
    public static final String MOVE_MESSAGES = "move-messages";
    public static final String LIST_MESSAGE_COUNTER = "list-message-counter";
    public static final String LIST_MESSAGE_COUNTER_AS_JSON = "list-message-counter-as-json";
    public static final String LIST_MESSAGE_COUNTER_AS_HTML = "list-message-counter-as-html";
    public static final String RESET_MESSAGE_COUNTER = "reset-message-counter";
    public static final String LIST_MESSAGE_COUNTER_HISTORY = "list-message-counter-history";
    public static final String LIST_MESSAGE_COUNTER_HISTORY_AS_JSON = "list-message-counter-history-as-json";
    public static final String LIST_MESSAGE_COUNTER_HISTORY_AS_HTML = "list-message-counter-history-as-html";
    public static final String PAUSE = "pause";
    public static final String RESUME = "resume";
    public static final String LIST_CONSUMERS = "list-consumers";
    public static final String LIST_CONSUMERS_AS_JSON = "list-consumers-as-json";
    public static final String MESSAGE_ID = "message-id";
    public static final String NEW_PRIORITY = "new-priority";
    public static final String OTHER_QUEUE_NAME = "other-queue-name";
    public static final String REJECT_DUPLICATES = "reject-duplicates";
    private final ParametersValidator singleOptionalFilterValidator = new ParametersValidator();
    private final ParametersValidator singleMessageIdValidator = new ParametersValidator();
    private final ParametersValidator changeMessagePriorityValidator = new ParametersValidator();
    private final ParametersValidator changeMessagesPriorityValidator = new ParametersValidator();
    private final ParametersValidator moveMessageValidator = new ParametersValidator();
    private final ParametersValidator moveMessagesValidator = new ParametersValidator();

    protected AbstractQueueControlHandler(ParameterValidator messageIdValidator) {
        ModelTypeValidator filterValidator = new ModelTypeValidator(ModelType.STRING, true, false);
        StringLengthValidator queueNameValidator = new StringLengthValidator(1);
        ModelTypeValidator rejectDuplicatesValidator = new ModelTypeValidator(ModelType.BOOLEAN, true);
        IntRangeValidator priorityValidator = new IntRangeValidator(0, 9, false, false);
        this.singleOptionalFilterValidator.registerValidator(CommonAttributes.FILTER.getName(), (ParameterValidator)filterValidator);
        this.singleMessageIdValidator.registerValidator(MESSAGE_ID, messageIdValidator);
        this.changeMessagePriorityValidator.registerValidator(MESSAGE_ID, messageIdValidator);
        this.changeMessagePriorityValidator.registerValidator(NEW_PRIORITY, (ParameterValidator)priorityValidator);
        this.changeMessagesPriorityValidator.registerValidator(CommonAttributes.FILTER.getName(), (ParameterValidator)filterValidator);
        this.changeMessagesPriorityValidator.registerValidator(NEW_PRIORITY, (ParameterValidator)priorityValidator);
        this.moveMessageValidator.registerValidator(MESSAGE_ID, messageIdValidator);
        this.moveMessageValidator.registerValidator(OTHER_QUEUE_NAME, (ParameterValidator)queueNameValidator);
        this.moveMessageValidator.registerValidator(REJECT_DUPLICATES, (ParameterValidator)rejectDuplicatesValidator);
        this.moveMessagesValidator.registerValidator(CommonAttributes.FILTER.getName(), (ParameterValidator)filterValidator);
        this.moveMessagesValidator.registerValidator(OTHER_QUEUE_NAME, (ParameterValidator)queueNameValidator);
        this.moveMessagesValidator.registerValidator(REJECT_DUPLICATES, (ParameterValidator)rejectDuplicatesValidator);
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        final boolean forJMS = this.isJMS();
        EnumSet<OperationEntry.Flag> readOnly = EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY);
        EnumSet<OperationEntry.Flag> runtimeOnly = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
        registry.registerOperationHandler(LIST_MESSAGES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListMessages(locale, forJMS, false);
            }
        }, false, OperationEntry.EntryType.PUBLIC, readOnly);
        registry.registerOperationHandler(LIST_MESSAGES_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListMessages(locale, forJMS, true);
            }
        }, readOnly);
        registry.registerOperationHandler(COUNT_MESSAGES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getCountMessages(locale);
            }
        }, readOnly);
        registry.registerOperationHandler(REMOVE_MESSAGE, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getRemoveMessage(locale, forJMS);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(REMOVE_MESSAGES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getRemoveMessages(locale);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(EXPIRE_MESSAGES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getExpireMessages(locale);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(EXPIRE_MESSAGE, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getExpireMessage(locale, forJMS);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(SEND_MESSAGE_TO_DEAD_LETTER_ADDRESS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSendMessageToDeadLetterAddress(locale, forJMS);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(SEND_MESSAGES_TO_DEAD_LETTER_ADDRESS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSendMessagesToDeadLetterAddress(locale);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(CHANGE_MESSAGE_PRIORITY, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getChangeMessagePriority(locale, forJMS);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(CHANGE_MESSAGES_PRIORITY, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getChangeMessagesPriority(locale);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(MOVE_MESSAGE, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getMoveMessage(locale, forJMS);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(MOVE_MESSAGES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getMoveMessages(locale);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(LIST_MESSAGE_COUNTER_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, AbstractQueueControlHandler.LIST_MESSAGE_COUNTER_AS_JSON, "queue", ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_MESSAGE_COUNTER_AS_HTML, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, AbstractQueueControlHandler.LIST_MESSAGE_COUNTER_AS_HTML, "queue", ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(RESET_MESSAGE_COUNTER, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, AbstractQueueControlHandler.RESET_MESSAGE_COUNTER, "queue");
            }
        }, runtimeOnly);
        registry.registerOperationHandler(LIST_MESSAGE_COUNTER_HISTORY_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, AbstractQueueControlHandler.LIST_MESSAGE_COUNTER_HISTORY_AS_JSON, "queue", ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_MESSAGE_COUNTER_HISTORY_AS_HTML, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, AbstractQueueControlHandler.LIST_MESSAGE_COUNTER_HISTORY_AS_HTML, "queue", ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(PAUSE, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, AbstractQueueControlHandler.PAUSE, "queue");
            }
        }, runtimeOnly);
        registry.registerOperationHandler(RESUME, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, AbstractQueueControlHandler.RESUME, "queue");
            }
        }, runtimeOnly);
        registry.registerOperationHandler(LIST_CONSUMERS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, AbstractQueueControlHandler.LIST_CONSUMERS_AS_JSON, "queue", ModelType.STRING, true);
            }
        }, readOnly);
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        String queueName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        DelegatingQueueControl<T> control = this.getQueueControl(hqServer, queueName);
        boolean reversible = false;
        Object handback = null;
        try {
            if (LIST_MESSAGES.equals(operationName)) {
                String json = control.listMessagesAsJSON(this.getFilter(operation));
                context.getResult().set(ModelNode.fromJSONString((String)json));
            } else if (LIST_MESSAGES_AS_JSON.equals(operationName)) {
                context.getResult().set(control.listMessagesAsJSON(this.getFilter(operation)));
            } else if (COUNT_MESSAGES.equals(operationName)) {
                context.getResult().set(control.countMessages(this.getFilter(operation)));
            } else if (REMOVE_MESSAGE.equals(operationName)) {
                this.singleMessageIdValidator.validate(operation);
                ModelNode id = operation.require(MESSAGE_ID);
                context.getResult().set(control.removeMessage(id));
            } else if (REMOVE_MESSAGES.equals(operationName)) {
                context.getResult().set(control.removeMessages(this.getFilter(operation)));
            } else if (EXPIRE_MESSAGES.equals(operationName)) {
                context.getResult().set(control.expireMessages(this.getFilter(operation)));
            } else if (EXPIRE_MESSAGE.equals(operationName)) {
                this.singleMessageIdValidator.validate(operation);
                ModelNode id = operation.require(MESSAGE_ID);
                context.getResult().set(control.expireMessage(id));
            } else if (SEND_MESSAGE_TO_DEAD_LETTER_ADDRESS.equals(operationName)) {
                this.singleMessageIdValidator.validate(operation);
                ModelNode id = operation.require(MESSAGE_ID);
                context.getResult().set(control.sendMessageToDeadLetterAddress(id));
            } else if (SEND_MESSAGES_TO_DEAD_LETTER_ADDRESS.equals(operationName)) {
                context.getResult().set(control.sendMessagesToDeadLetterAddress(this.getFilter(operation)));
            } else if (CHANGE_MESSAGE_PRIORITY.equals(operationName)) {
                this.changeMessagePriorityValidator.validate(operation);
                ModelNode id = operation.require(MESSAGE_ID);
                int priority = operation.require(NEW_PRIORITY).asInt();
                context.getResult().set(control.changeMessagePriority(id, priority));
            } else if (CHANGE_MESSAGES_PRIORITY.equals(operationName)) {
                this.changeMessagesPriorityValidator.validate(operation);
                int priority = operation.require(NEW_PRIORITY).asInt();
                context.getResult().set(control.changeMessagesPriority(this.getFilter(operation), priority));
            } else if (MOVE_MESSAGE.equals(operationName)) {
                this.moveMessageValidator.validate(operation);
                ModelNode id = operation.require(MESSAGE_ID);
                String otherQueue = operation.require(OTHER_QUEUE_NAME).asString();
                if (operation.hasDefined(REJECT_DUPLICATES)) {
                    boolean reject = operation.get(REJECT_DUPLICATES).asBoolean();
                    context.getResult().set(control.moveMessage(id, otherQueue, reject));
                } else {
                    context.getResult().set(control.moveMessage(id, otherQueue));
                }
            } else if (MOVE_MESSAGES.equals(operationName)) {
                this.moveMessagesValidator.validate(operation);
                String otherQueue = operation.require(OTHER_QUEUE_NAME).asString();
                if (operation.hasDefined(REJECT_DUPLICATES)) {
                    boolean reject = operation.get(REJECT_DUPLICATES).asBoolean();
                    context.getResult().set(control.moveMessages(this.getFilter(operation), otherQueue, reject));
                } else {
                    context.getResult().set(control.moveMessages(this.getFilter(operation), otherQueue));
                }
            } else if (LIST_MESSAGE_COUNTER_AS_JSON.equals(operationName)) {
                context.getResult().set(control.listMessageCounter());
            } else if (LIST_MESSAGE_COUNTER_AS_HTML.equals(operationName)) {
                context.getResult().set(control.listMessageCounterAsHTML());
            } else if (LIST_MESSAGE_COUNTER_HISTORY_AS_JSON.equals(operationName)) {
                context.getResult().set(control.listMessageCounterHistory());
            } else if (LIST_MESSAGE_COUNTER_HISTORY_AS_HTML.equals(operationName)) {
                context.getResult().set(control.listMessageCounterHistoryAsHTML());
            } else if (RESET_MESSAGE_COUNTER.equals(operationName)) {
                control.resetMessageCounter();
                context.getResult();
            } else if (PAUSE.equals(operationName)) {
                control.pause();
                reversible = true;
                context.getResult();
            } else if (RESUME.equals(operationName)) {
                control.resume();
                reversible = true;
                context.getResult();
            } else if (LIST_CONSUMERS_AS_JSON.equals(operationName)) {
                context.getResult().set(control.listConsumersAsJSON());
            } else {
                handback = this.handleAdditionalOperation(operationName, operation, context, control.getDelegate());
                reversible = handback == null;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
        if (context.completeStep() != OperationContext.ResultAction.KEEP && reversible) {
            try {
                if (PAUSE.equals(operationName)) {
                    control.resume();
                } else if (RESUME.equals(operationName)) {
                    control.pause();
                } else {
                    this.revertAdditionalOperation(operationName, operation, context, control.getDelegate(), handback);
                }
            }
            catch (Exception e) {
                MessagingLogger.ROOT_LOGGER.revertOperationFailed(e, ((Object)((Object)this)).getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress((ModelNode)operation.require("address")));
            }
        }
    }

    protected abstract DelegatingQueueControl<T> getQueueControl(HornetQServer var1, String var2);

    protected abstract Object handleAdditionalOperation(String var1, ModelNode var2, OperationContext var3, T var4) throws OperationFailedException;

    protected abstract void revertAdditionalOperation(String var1, ModelNode var2, OperationContext var3, T var4, Object var5);

    protected abstract boolean isJMS();

    protected final void throwUnimplementedOperationException(String operationName) {
        throw MessagingMessages.MESSAGES.unsupportedOperation(operationName);
    }

    private String getFilter(ModelNode operation) throws OperationFailedException {
        this.singleOptionalFilterValidator.validate(operation);
        String filter = operation.hasDefined(CommonAttributes.FILTER.getName()) ? operation.get(CommonAttributes.FILTER.getName()).asString() : null;
        return filter;
    }

    public static interface DelegatingQueueControl<T> {
        public T getDelegate();

        public String listMessagesAsJSON(String var1) throws Exception;

        public long countMessages(String var1) throws Exception;

        public boolean removeMessage(ModelNode var1) throws Exception;

        public int removeMessages(String var1) throws Exception;

        public int expireMessages(String var1) throws Exception;

        public boolean expireMessage(ModelNode var1) throws Exception;

        public boolean sendMessageToDeadLetterAddress(ModelNode var1) throws Exception;

        public int sendMessagesToDeadLetterAddress(String var1) throws Exception;

        public boolean changeMessagePriority(ModelNode var1, int var2) throws Exception;

        public int changeMessagesPriority(String var1, int var2) throws Exception;

        public boolean moveMessage(ModelNode var1, String var2) throws Exception;

        public boolean moveMessage(ModelNode var1, String var2, boolean var3) throws Exception;

        public int moveMessages(String var1, String var2) throws Exception;

        public int moveMessages(String var1, String var2, boolean var3) throws Exception;

        public String listMessageCounter() throws Exception;

        public void resetMessageCounter() throws Exception;

        public String listMessageCounterAsHTML() throws Exception;

        public String listMessageCounterHistory() throws Exception;

        public String listMessageCounterHistoryAsHTML() throws Exception;

        public void pause() throws Exception;

        public void resume() throws Exception;

        public String listConsumersAsJSON() throws Exception;
    }
}

