/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingSubsystemParser;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.jms.JndiEntriesAttribute;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class Messaging12SubsystemParser
extends MessagingSubsystemParser {
    private static final Messaging12SubsystemParser INSTANCE = new Messaging12SubsystemParser();

    public static MessagingSubsystemParser getInstance() {
        return INSTANCE;
    }

    protected Messaging12SubsystemParser() {
    }

    @Override
    public Namespace getExpectedNamespace() {
        return Namespace.MESSAGING_1_2;
    }

    @Override
    protected void writePooledConnectionFactoryAttributes(XMLExtendedStreamWriter writer, String name, ModelNode factory) throws XMLStreamException {
        super.writePooledConnectionFactoryAttributes(writer, name, factory);
        CommonAttributes.MIN_POOL_SIZE.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.MAX_POOL_SIZE.marshallAsElement(factory, (XMLStreamWriter)writer);
    }

    @Override
    protected ModelNode createConnectionFactory(XMLExtendedStreamReader reader, ModelNode connectionFactory, boolean pooled) throws XMLStreamException {
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            switch (element) {
                case DISCOVERY_GROUP_REF: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.DISCOVERY_GROUP_REF, Element.CONNECTORS);
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.DISCOVERY_GROUP_NAME.getXmlName());
                    CommonAttributes.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, connectionFactory, (XMLStreamReader)reader);
                    continue block17;
                }
                case CONNECTORS: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.CONNECTORS, Element.DISCOVERY_GROUP_REF);
                    connectionFactory.get("connector").set(Messaging12SubsystemParser.processJmsConnectors(reader));
                    continue block17;
                }
                case ENTRIES: {
                    Element local;
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        local = Element.forName(reader.getLocalName());
                        if (local != Element.ENTRY) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        String entry = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                        JndiEntriesAttribute.CONNECTION_FACTORY.parseAndAddParameterElement(entry, connectionFactory, (XMLStreamReader)reader);
                    }
                    continue block17;
                }
                case HA: 
                case CLIENT_FAILURE_CHECK_PERIOD: 
                case CONNECTION_TTL: 
                case CALL_TIMEOUT: 
                case CONSUMER_WINDOW_SIZE: 
                case CONSUMER_MAX_RATE: 
                case CONFIRMATION_WINDOW_SIZE: 
                case PRODUCER_WINDOW_SIZE: 
                case PRODUCER_MAX_RATE: 
                case CACHE_LARGE_MESSAGE_CLIENT: 
                case MIN_LARGE_MESSAGE_SIZE: 
                case CLIENT_ID: 
                case DUPS_OK_BATCH_SIZE: 
                case TRANSACTION_BATH_SIZE: 
                case BLOCK_ON_ACK: 
                case BLOCK_ON_NON_DURABLE_SEND: 
                case BLOCK_ON_DURABLE_SEND: 
                case AUTO_GROUP: 
                case PRE_ACK: 
                case RETRY_INTERVAL_MULTIPLIER: 
                case MAX_RETRY_INTERVAL: 
                case FAILOVER_ON_INITIAL_CONNECTION: 
                case FAILOVER_ON_SERVER_SHUTDOWN: 
                case LOAD_BALANCING_CLASS_NAME: 
                case USE_GLOBAL_POOLS: 
                case GROUP_ID: {
                    Messaging12SubsystemParser.handleElementText(reader, element, connectionFactory);
                    continue block17;
                }
                case RETRY_INTERVAL: {
                    Messaging12SubsystemParser.handleElementText(reader, element, "default", connectionFactory);
                    continue block17;
                }
                case RECONNECT_ATTEMPTS: 
                case SCHEDULED_THREAD_POOL_MAX_SIZE: 
                case THREAD_POOL_MAX_SIZE: {
                    Messaging12SubsystemParser.handleElementText(reader, element, "connection", connectionFactory);
                    continue block17;
                }
                case CONNECTION_FACTORY_TYPE: {
                    if (pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    Messaging12SubsystemParser.handleElementText(reader, element, connectionFactory);
                    continue block17;
                }
                case INBOUND_CONFIG: {
                    Element local;
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    block19: while (reader.hasNext() && reader.nextTag() != 2) {
                        local = Element.forName(reader.getLocalName());
                        switch (local) {
                            case USE_JNDI: 
                            case JNDI_PARAMS: 
                            case USE_LOCAL_TX: 
                            case SETUP_ATTEMPTS: 
                            case SETUP_INTERVAL: {
                                Messaging12SubsystemParser.handleElementText(reader, local, connectionFactory);
                                continue block19;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block17;
                }
                case TRANSACTION: {
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    String txType = reader.getAttributeValue(0);
                    if (txType != null) {
                        connectionFactory.get("transaction").set(txType);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block17;
                }
                case USER: {
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    CommonAttributes.PCF_USER.parseAndSetParameter(reader.getElementText(), connectionFactory, (XMLStreamReader)reader);
                    continue block17;
                }
                case PASSWORD: {
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    CommonAttributes.PCF_PASSWORD.parseAndSetParameter(reader.getElementText(), connectionFactory, (XMLStreamReader)reader);
                    continue block17;
                }
                case MAX_POOL_SIZE: 
                case MIN_POOL_SIZE: {
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    Messaging12SubsystemParser.handleElementText(reader, element, connectionFactory);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        this.checkOnlyOneOfElements(reader, seen, Element.CONNECTORS, Element.DISCOVERY_GROUP_REF);
        return connectionFactory;
    }

    @Override
    protected void processBridge(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode bridgeAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("bridge", name));
        EnumSet<Element> required = EnumSet.of(Element.QUEUE_NAME);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case HA: 
                case CONNECTION_TTL: 
                case CONFIRMATION_WINDOW_SIZE: 
                case MIN_LARGE_MESSAGE_SIZE: 
                case RETRY_INTERVAL_MULTIPLIER: 
                case MAX_RETRY_INTERVAL: 
                case FAILOVER_ON_SERVER_SHUTDOWN: 
                case USER: 
                case PASSWORD: 
                case CHECK_PERIOD: 
                case QUEUE_NAME: 
                case TRANSFORMER_CLASS_NAME: {
                    Messaging12SubsystemParser.handleElementText(reader, element, bridgeAdd);
                    continue block8;
                }
                case FILTER: {
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.FILTER.parseAndSetParameter(string, bridgeAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                case RETRY_INTERVAL: {
                    Messaging12SubsystemParser.handleElementText(reader, element, "default", bridgeAdd);
                    continue block8;
                }
                case RECONNECT_ATTEMPTS: 
                case FORWARDING_ADDRESS: 
                case USE_DUPLICATE_DETECTION: {
                    Messaging12SubsystemParser.handleElementText(reader, element, "bridge", bridgeAdd);
                    continue block8;
                }
                case STATIC_CONNECTORS: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
                    this.processStaticConnectors(reader, bridgeAdd, false);
                    continue block8;
                }
                case DISCOVERY_GROUP_REF: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.DISCOVERY_GROUP_REF, Element.STATIC_CONNECTORS);
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.DISCOVERY_GROUP_NAME.getXmlName());
                    CommonAttributes.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, bridgeAdd, (XMLStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        this.checkOnlyOneOfElements(reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(bridgeAdd);
    }

    @Override
    protected void processClusterConnection(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode clusterConnectionAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("cluster-connection", name));
        EnumSet<Element> required = EnumSet.of(Element.ADDRESS, Element.CONNECTOR_REF);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case CALL_TIMEOUT: 
                case CONFIRMATION_WINDOW_SIZE: 
                case MIN_LARGE_MESSAGE_SIZE: 
                case FORWARD_WHEN_NO_CONSUMERS: 
                case MAX_HOPS: {
                    Messaging12SubsystemParser.handleElementText(reader, element, clusterConnectionAdd);
                    continue block8;
                }
                case ADDRESS: {
                    Messaging12SubsystemParser.handleElementText(reader, element, CommonAttributes.CLUSTER_CONNECTION_ADDRESS.getName(), clusterConnectionAdd);
                    continue block8;
                }
                case CONNECTOR_REF: {
                    Messaging12SubsystemParser.handleElementText(reader, element, "simple", clusterConnectionAdd);
                    continue block8;
                }
                case CONNECTION_TTL: 
                case RETRY_INTERVAL_MULTIPLIER: 
                case MAX_RETRY_INTERVAL: 
                case RETRY_INTERVAL: 
                case RECONNECT_ATTEMPTS: 
                case CHECK_PERIOD: 
                case USE_DUPLICATE_DETECTION: {
                    Messaging12SubsystemParser.handleElementText(reader, element, "cluster", clusterConnectionAdd);
                    continue block8;
                }
                case STATIC_CONNECTORS: {
                    if (seen.contains((Object)Element.DISCOVERY_GROUP_REF)) {
                        throw new XMLStreamException(MessagingMessages.MESSAGES.illegalElement("static-connectors", "discovery-group-ref"), reader.getLocation());
                    }
                    this.processStaticConnectors(reader, clusterConnectionAdd, true);
                    continue block8;
                }
                case DISCOVERY_GROUP_REF: {
                    if (seen.contains((Object)Element.STATIC_CONNECTORS)) {
                        throw new XMLStreamException(MessagingMessages.MESSAGES.illegalElement("discovery-group-ref", "static-connectors"), reader.getLocation());
                    }
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.DISCOVERY_GROUP_NAME.getXmlName());
                    CommonAttributes.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, clusterConnectionAdd, (XMLStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        this.checkOnlyOneOfElements(reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(clusterConnectionAdd);
    }
}

