/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.osgi.repository.ArtifactProviderPlugin;
import org.jboss.osgi.repository.RepositoryCachePlugin;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.repository.Repository;

public final class RepositoryImpl
implements Repository {
    private static Logger log = Logger.getLogger(RepositoryImpl.class);
    private final ArtifactProviderPlugin provider;
    private final RepositoryCachePlugin cache;

    public RepositoryImpl(ArtifactProviderPlugin provider, RepositoryCachePlugin cache) {
        this.provider = provider;
        this.cache = cache;
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> reqs) {
        log.infof("find providers for: %s", reqs);
        HashMap result = new HashMap();
        for (Requirement requirement : reqs) {
            Collection caps = this.cache.findProviders(requirement);
            if (caps.isEmpty()) {
                caps = this.provider.findProviders(requirement);
                caps = this.cache.storeCapabilities(caps);
            }
            log.infof("found matching caps: %s", (Object)caps);
            result.put(requirement, Collections.unmodifiableCollection(caps));
        }
        return Collections.unmodifiableMap(result);
    }
}

