/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.felix;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.felix.resolver.FelixResolveContext;
import org.apache.felix.resolver.impl.HostedRequirement;
import org.apache.felix.resolver.impl.ResolverImpl;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.felix.LoggerDelegate;
import org.jboss.osgi.resolver.internal.ResolverLogger;
import org.jboss.osgi.resolver.spi.AbstractResolveContext;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

public class StatelessResolver
implements XResolver {
    private ResolverImpl delegate = new ResolverImpl(new LoggerDelegate());

    public Map<Resource, List<Wire>> resolve(ResolveContext context) throws ResolutionException {
        ResolveContextDelegate env = new ResolveContextDelegate((XResolveContext)context);
        Collection mandatory = context.getMandatoryResources();
        Collection optional = context.getOptionalResources();
        ResolverLogger.LOGGER.debugf("Resolve: %s, %s", (Object)mandatory, (Object)optional);
        Map<Resource, List<Wire>> result = this.delegate.resolve(env);
        if (ResolverLogger.LOGGER.isDebugEnabled()) {
            ResolverLogger.LOGGER.debugf("Resolution result: %d", (Object)result.size());
            for (Map.Entry<Resource, List<Wire>> entry : result.entrySet()) {
                Resource res = entry.getKey();
                List<Wire> wires = entry.getValue();
                ResolverLogger.LOGGER.debugf("   %s: %d wires", (Object)res, (Object)wires.size());
                for (Wire wire : wires) {
                    ResolverLogger.LOGGER.debugf("      %s", (Object)wire);
                }
            }
        }
        return result;
    }

    public synchronized Map<Resource, Wiring> resolveAndApply(XResolveContext context) throws ResolutionException {
        Map<Resource, List<Wire>> wiremap = this.resolve((ResolveContext)context);
        return context.getEnvironment().updateWiring(wiremap);
    }

    public XResolveContext createResolverContext(XEnvironment environment, final Collection<Resource> mandatory, final Collection<Resource> optional) {
        return new AbstractResolveContext(environment){

            public Collection<Resource> getMandatoryResources() {
                return mandatory != null ? mandatory : super.getMandatoryResources();
            }

            public Collection<Resource> getOptionalResources() {
                return optional != null ? optional : super.getOptionalResources();
            }
        };
    }

    static class ResolveContextDelegate
    extends FelixResolveContext {
        private final XResolveContext context;

        ResolveContextDelegate(XResolveContext context) {
            this.context = context;
        }

        public boolean isEffective(Requirement req) {
            return this.context.isEffective(req);
        }

        public Map<Resource, Wiring> getWirings() {
            return this.context.getWirings();
        }

        public Collection<Resource> getMandatoryResources() {
            return this.context.getMandatoryResources();
        }

        public Collection<Resource> getOptionalResources() {
            return this.context.getOptionalResources();
        }

        public List<Capability> findProviders(Requirement req) {
            return this.context.findProviders(req);
        }

        public int insertHostedCapability(List<Capability> capabilities, HostedCapability hostedCapability) {
            return this.context.insertHostedCapability(capabilities, hostedCapability);
        }

        @Override
        public boolean matches(Requirement req, Capability cap) {
            XRequirement xreq = (XRequirement)(req instanceof HostedRequirement ? ((HostedRequirement)req).getOriginalRequirement() : req);
            return xreq.matches((XCapability)cap);
        }

        @Override
        public void checkExecutionEnvironment(Resource resource) throws ResolutionException {
        }

        @Override
        public void checkNativeLibraries(Resource resource) throws ResolutionException {
        }
    }
}

