/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.jaxrpc.ParameterWrapping;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.utils.HolderUtils;
import org.jboss.ws.core.utils.MimeUtils;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.w3c.dom.Element;

public class EndpointInvocation {
    private static final ResourceBundle bundle = BundleUtils.getBundle(EndpointInvocation.class);
    private static final Logger log = Logger.getLogger(EndpointInvocation.class);
    private OperationMetaData opMetaData;
    private Map<QName, Object> reqPayload = new LinkedHashMap<QName, Object>();
    private Map<QName, Object> resPayload = new LinkedHashMap<QName, Object>();
    private Object returnValue;
    private Map<Integer, Object> outParameters = new HashMap<Integer, Object>();

    public EndpointInvocation(OperationMetaData opMetaData) {
        this.opMetaData = opMetaData;
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public Method getJavaMethod() {
        return this.opMetaData.getJavaMethod();
    }

    public Map<Integer, Object> getOutParameters() {
        return this.outParameters;
    }

    public List<QName> getRequestParamNames() {
        ArrayList<QName> xmlNames = new ArrayList<QName>();
        xmlNames.addAll(this.reqPayload.keySet());
        return xmlNames;
    }

    public void setRequestParamValue(QName xmlName, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setRequestParamValue: [name=" + xmlName + ",value=" + this.getTypeName(value) + "]"));
        }
        this.reqPayload.put(xmlName, value);
    }

    public Object getRequestParamValue(QName xmlName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRequestParamValue: " + xmlName));
        }
        Object paramValue = this.reqPayload.get(xmlName);
        ParameterMetaData paramMetaData = this.opMetaData.getParameter(xmlName);
        try {
            paramValue = this.transformPayloadValue(paramMetaData, paramValue);
        }
        catch (SOAPException ex) {
            throw new WSException(ex);
        }
        return paramValue;
    }

    public Object[] getRequestPayload() {
        log.debug((Object)"getRequestPayload");
        List<QName> xmlNames = this.getRequestParamNames();
        Object[] payload = new Object[this.opMetaData.getJavaMethod().getParameterTypes().length];
        for (int i = 0; i < xmlNames.size(); ++i) {
            QName xmlName = xmlNames.get(i);
            Object paramValue = this.getRequestParamValue(xmlName);
            ParameterMetaData paramMetaData = this.opMetaData.getParameter(xmlName);
            this.syncEndpointInputParam(paramMetaData, paramValue, payload);
        }
        return payload;
    }

    public List<QName> getResponseParamNames() {
        ArrayList<QName> xmlNames = new ArrayList<QName>();
        xmlNames.addAll(this.resPayload.keySet());
        return xmlNames;
    }

    public void setResponseParamValue(QName xmlName, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setResponseParamValue: [name=" + xmlName + ",value=" + this.getTypeName(value) + "]"));
        }
        this.resPayload.put(xmlName, value);
    }

    public Object getResponseParamValue(QName xmlName) throws SOAPException {
        Class<?> valueType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResponseParamValue: " + xmlName));
        }
        Object paramValue = this.resPayload.get(xmlName);
        ParameterMetaData paramMetaData = this.opMetaData.getParameter(xmlName);
        paramValue = this.transformPayloadValue(paramMetaData, paramValue);
        if (paramValue != null && HolderUtils.isHolderType(valueType = paramValue.getClass())) {
            paramValue = HolderUtils.getHolderValue(paramValue);
        }
        return paramValue;
    }

    public void setReturnValue(Object value) {
        ParameterMetaData retMetaData = this.opMetaData.getReturnParameter();
        if (value != null && retMetaData == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"OPERATION_DOES_NOT_HAVE_A_RETURN_VALUE", (Object[])new Object[]{this.opMetaData.getQName()}));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setReturnValue: " + this.getTypeName(value)));
        }
        this.returnValue = value;
    }

    public Object getReturnValue() {
        log.debug((Object)"getReturnValue");
        Object paramValue = this.returnValue;
        ParameterMetaData paramMetaData = this.opMetaData.getReturnParameter();
        if (paramMetaData != null) {
            try {
                paramValue = this.transformPayloadValue(paramMetaData, paramValue);
            }
            catch (SOAPException ex) {
                throw new WSException(ex);
            }
        }
        return paramValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object transformPayloadValue(ParameterMetaData paramMetaData, Object paramValue) throws SOAPException {
        QName xmlName = paramMetaData.getXmlName();
        QName xmlType = paramMetaData.getXmlType();
        Class javaType = paramMetaData.getJavaType();
        String javaName = paramMetaData.getJavaTypeName();
        if (xmlType == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_XML_TYPE", (Object[])new Object[]{xmlName, javaName}));
        }
        Object retValue = paramValue;
        if (paramValue instanceof AttachmentPart) {
            AttachmentPart part = (AttachmentPart)paramValue;
            Set<String> mimeTypes = paramMetaData.getMimeTypes();
            if (DataHandler.class.isAssignableFrom(javaType) && !javaType.equals(Object.class)) {
                DataHandler handler = part.getDataHandler();
                String mimeType = MimeUtils.getBaseMimeType(handler.getContentType());
                if (mimeTypes != null && !MimeUtils.isMemberOf(mimeType, mimeTypes)) {
                    log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"MIME_TYPE_NOT_ALLOWED", (Object[])new Object[]{mimeType, xmlName, mimeTypes}));
                }
                retValue = part.getDataHandler();
            } else {
                Class<?> valueType;
                retValue = part.getContent();
                String mimeType = MimeUtils.getBaseMimeType(part.getContentType());
                if (mimeTypes != null && !MimeUtils.isMemberOf(mimeType, mimeTypes)) {
                    throw new SOAPException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MIME_TYPE_NOT_ALLOWED", (Object[])new Object[]{mimeType, xmlName, mimeTypes}));
                }
                if (retValue != null && !JavaUtils.isAssignableFrom((Class)javaType, valueType = retValue.getClass())) {
                    if (!(retValue instanceof InputStream)) throw new SOAPException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"JAVATYPE_IS_NOT_ASSIGNABLE", (Object[])new Object[]{javaType.getName(), valueType.getName()}));
                    MimeUtils.ByteArrayConverter converter = MimeUtils.getConverterForJavaType(javaType);
                    retValue = converter.readFrom((InputStream)retValue);
                }
            }
        } else if (paramValue instanceof SOAPContentElement && !Element.class.isAssignableFrom(javaType)) {
            SOAPContentElement soapElement = (SOAPContentElement)paramValue;
            retValue = soapElement.getObjectValue();
        }
        if (!log.isDebugEnabled()) return retValue;
        log.debug((Object)("transformPayloadValue: " + this.getTypeName(paramValue) + " -> " + this.getTypeName(retValue)));
        return retValue;
    }

    public void initInputParams(Object[] inputParams) {
        for (ParameterMetaData paramMetaData : this.opMetaData.getParameters()) {
            Object value;
            int index = paramMetaData.getIndex();
            if (index < 0) continue;
            QName xmlName = paramMetaData.getXmlName();
            Class javaType = paramMetaData.getJavaType();
            if (this.opMetaData.isDocumentWrapped() && !paramMetaData.isInHeader() && !paramMetaData.isSwA()) {
                value = ParameterWrapping.wrapRequestParameters(paramMetaData, inputParams);
            } else {
                value = inputParams[index];
                if (value != null) {
                    Class<?> inputType = value.getClass();
                    if (HolderUtils.isHolderType(inputType)) {
                        Class<?> clazz = inputType = (value = HolderUtils.getHolderValue(value)) == null ? null : value.getClass();
                    }
                    if (!(value == null || paramMetaData.isSwA() || paramMetaData.isXOP() || JavaUtils.isAssignableFrom((Class)javaType, inputType))) {
                        throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"PARAMETER_NOT_ASSIGNABLE", (Object[])new Object[]{javaType, inputType}));
                    }
                }
            }
            this.setRequestParamValue(xmlName, value);
        }
    }

    private void syncEndpointInputParam(ParameterMetaData paramMetaData, Object paramValue, Object[] payload) {
        Object retValue = paramValue;
        Method method = this.opMetaData.getJavaMethod();
        Class[] targetParameterTypes = method.getParameterTypes();
        if (this.opMetaData.isDocumentWrapped() && !paramMetaData.isInHeader() && !paramMetaData.isSwA() && !paramMetaData.isMessageType()) {
            this.outParameters = ParameterWrapping.unwrapRequestParameters(paramMetaData, paramValue, payload);
            this.syncOutWrappedParameters(targetParameterTypes, payload);
        } else {
            int index = paramMetaData.getIndex();
            Class<?> targetParameterType = targetParameterTypes[index];
            if (paramMetaData.getMode() == ParameterMode.INOUT || paramMetaData.getMode() == ParameterMode.OUT) {
                retValue = HolderUtils.createHolderInstance(paramValue, targetParameterType);
                QName xmlName = paramMetaData.getXmlName();
                this.setResponseParamValue(xmlName, retValue);
            }
            if (retValue != null) {
                Class<?> valueType = retValue.getClass();
                if (!JavaUtils.isAssignableFrom(targetParameterType, valueType)) {
                    throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"PARAMETER_NOT_ASSIGNABLE", (Object[])new Object[]{targetParameterType.getName(), this.getTypeName(retValue)}));
                }
                if (valueType.isArray()) {
                    retValue = JavaUtils.syncArray((Object)retValue, targetParameterType);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("syncEndpointInputParam: " + this.getTypeName(paramValue) + " -> " + this.getTypeName(retValue) + "(" + index + ")"));
            }
            payload[index] = retValue;
        }
    }

    private void syncOutWrappedParameters(Class[] targetParameterTypes, Object[] payload) {
        ParameterMetaData returnMetaData = this.opMetaData.getReturnParameter();
        if (returnMetaData != null) {
            for (WrappedParameter param : returnMetaData.getWrappedParameters()) {
                try {
                    if (param.getIndex() < 0 || this.outParameters.containsKey(param.getIndex())) continue;
                    Object holder = targetParameterTypes[param.getIndex()].newInstance();
                    payload[param.getIndex()] = holder;
                    this.outParameters.put(param.getIndex(), holder);
                }
                catch (Exception e) {
                    throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_ADD_OUTPUT_PARAM", (Object[])new Object[]{param.getName()}), e);
                }
            }
        }
    }

    private String getTypeName(Object value) {
        String valueType = value != null ? value.getClass().getName() : null;
        return valueType;
    }
}

