/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.http.HTTPBinding;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.EndpointInvocation;
import org.jboss.ws.core.HTTPMessageImpl;
import org.jboss.ws.core.HeaderSource;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.jaxws.binding.BindingExt;
import org.jboss.ws.core.jaxws.binding.BindingImpl;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.UnboundHeader;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public class HTTPBindingJAXWS
implements CommonBinding,
BindingExt,
HTTPBinding {
    private static final ResourceBundle bundle = BundleUtils.getBundle(HTTPBindingJAXWS.class);
    private static final Logger log = Logger.getLogger(HTTPBindingJAXWS.class);
    private BindingImpl delegate = new BindingImpl();

    @Override
    public MessageAbstraction bindRequestMessage(OperationMetaData opMetaData, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders) throws BindingException {
        throw new NotImplementedException();
    }

    @Override
    public EndpointInvocation unbindRequestMessage(OperationMetaData opMetaData, MessageAbstraction reqMessage) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("unbindRequestMessage: " + opMetaData.getQName()));
        }
        try {
            EndpointInvocation epInv = new EndpointInvocation(opMetaData);
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MESSAGECONTEXT_NOT_AVAILABLE", (Object[])new Object[0]));
            }
            ParameterMetaData paramMetaData = opMetaData.getParameters().get(0);
            QName xmlName = paramMetaData.getXmlName();
            HTTPMessageImpl httpMessage = (HTTPMessageImpl)reqMessage;
            Source source = httpMessage.getXmlFragment().getSource();
            epInv.setRequestParamValue(xmlName, source);
            return epInv;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public MessageAbstraction bindResponseMessage(OperationMetaData opMetaData, EndpointInvocation epInv) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("bindResponseMessage: " + opMetaData.getQName()));
        }
        try {
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MESSAGECONTEXT_NOT_AVAILABLE", (Object[])new Object[0]));
            }
            Source source = (Source)epInv.getReturnValue();
            HTTPMessageImpl resMessage = new HTTPMessageImpl(source);
            msgContext.setMessageAbstraction(resMessage);
            return resMessage;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void unbindResponseMessage(OperationMetaData opMetaData, MessageAbstraction resMessage, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders) throws BindingException {
        throw new NotImplementedException();
    }

    @Override
    public MessageAbstraction bindFaultMessage(Exception ex) {
        throw new NotImplementedException();
    }

    public List<Handler> getHandlerChain() {
        return this.delegate.getHandlerChain();
    }

    @Override
    public List<Handler> getHandlerChain(UnifiedHandlerMetaData.HandlerType handlerType) {
        return this.delegate.getHandlerChain(handlerType);
    }

    public void setHandlerChain(List<Handler> handlerChain) {
        for (Handler handler : handlerChain) {
            if (handler instanceof LogicalHandler) continue;
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ADDING_HANDLER_INCOMPATIABLE", (Object[])new Object[]{handler.getClass()}));
        }
        this.delegate.setHandlerChain(handlerChain);
    }

    @Override
    public void setHandlerChain(List<Handler> handlerChain, UnifiedHandlerMetaData.HandlerType handlerType) {
        this.delegate.setHandlerChain(handlerChain, handlerType);
    }

    public String getBindingID() {
        return "http://www.w3.org/2004/08/wsdl/http";
    }

    @Override
    public void setHeaderSource(HeaderSource source) {
    }

    private void handleException(Exception ex) throws BindingException {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof BindingException) {
            throw (BindingException)ex;
        }
        throw new BindingException(ex);
    }
}

