/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.ReferenceParameters;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.spi.ServiceDelegate;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.ResourceLoaderAdapter;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.ws.core.EndpointMetadataProvider;
import org.jboss.ws.core.StubExt;
import org.jboss.ws.core.jaxws.client.ClientFeatureProcessor;
import org.jboss.ws.core.jaxws.client.ClientImpl;
import org.jboss.ws.core.jaxws.client.ClientProxy;
import org.jboss.ws.core.jaxws.client.DispatchImpl;
import org.jboss.ws.core.jaxws.client.serviceref.NativeServiceObjectFactoryJAXWS;
import org.jboss.ws.core.jaxws.handler.HandlerResolverImpl;
import org.jboss.ws.core.jaxws.spi.ProviderImpl;
import org.jboss.ws.core.jaxws.wsaddressing.EndpointReferenceUtil;
import org.jboss.ws.core.jaxws.wsaddressing.NativeEndpointReference;
import org.jboss.ws.metadata.builder.jaxws.JAXWSClientMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilder;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.FeatureAwareClientEndpointMetaDataAdapter;
import org.jboss.ws.metadata.umdm.FeatureAwareEndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.w3c.dom.Element;

public class ServiceDelegateImpl
extends ServiceDelegate {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ServiceDelegateImpl.class);
    private static final Logger log = Logger.getLogger(ServiceDelegateImpl.class);
    private static final Object DEFAULT_EXECUTOR_LOCK = new Object();
    private static ExecutorService defaultExecutor = null;
    private ServiceMetaData serviceMetaData;
    private UnifiedServiceRefMetaData usRef;
    private HandlerResolver handlerResolver;
    private ExecutorService executor;
    private WebServiceFeature[] features;
    private List<QName> annotatedPorts = new ArrayList<QName>();

    public ServiceDelegateImpl(URL wsdlURL, QName serviceName, Class serviceClass, WebServiceFeature[] features) {
        this(wsdlURL, serviceName, serviceClass);
        this.features = features;
    }

    public ServiceDelegateImpl(URL wsdlURL, QName serviceName, Class serviceClass) {
        HandlerChain anHandlerChain;
        ResourceLoaderAdapter vfsRoot;
        this.usRef = NativeServiceObjectFactoryJAXWS.getServiceRefAssociation();
        ResourceLoaderAdapter resourceLoaderAdapter = vfsRoot = this.usRef != null ? (vfsRoot = this.usRef.getVfsRoot()) : new ResourceLoaderAdapter();
        if (wsdlURL != null && serviceClass != Service.class) {
            try {
                InputStream is = wsdlURL.openStream();
                is.close();
            }
            catch (IOException e) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_ACCESS_WSDLURL", (Object[])new Object[]{wsdlURL}));
                wsdlURL = null;
            }
        }
        if (wsdlURL != null) {
            JAXWSClientMetaDataBuilder builder = new JAXWSClientMetaDataBuilder();
            this.serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, (UnifiedVirtualFile)vfsRoot);
        } else {
            ClassLoader cl = serviceClass.getClassLoader();
            UnifiedMetaData wsMetaData = cl == null ? new UnifiedMetaData((UnifiedVirtualFile)vfsRoot) : new UnifiedMetaData((UnifiedVirtualFile)vfsRoot, cl);
            this.serviceMetaData = new ServiceMetaData(wsMetaData, serviceName);
            wsMetaData.addService(this.serviceMetaData);
        }
        this.handlerResolver = new HandlerResolverImpl();
        String filename = null;
        if (this.usRef != null) {
            this.serviceMetaData.setServiceRefName(this.usRef.getServiceRefName());
            if (this.usRef.getHandlerChain() != null) {
                filename = this.usRef.getHandlerChain();
            }
        }
        if (serviceClass != null && serviceClass.getAnnotation(HandlerChain.class) != null && (anHandlerChain = serviceClass.getAnnotation(HandlerChain.class)) != null && anHandlerChain.file().length() > 0) {
            filename = anHandlerChain.file();
            try {
                new URL(filename);
            }
            catch (MalformedURLException ex) {
                filename = serviceClass.getPackage().getName().replace('.', '/') + "/" + filename;
            }
        }
        if (filename != null) {
            UnifiedHandlerChainsMetaData handlerChainsMetaData = JAXWSMetaDataBuilder.getHandlerChainsMetaData(serviceClass, filename);
            for (UnifiedHandlerChainMetaData UnifiedHandlerChainMetaData2 : handlerChainsMetaData.getHandlerChains()) {
                for (UnifiedHandlerMetaData uhmd : UnifiedHandlerChainMetaData2.getHandlers()) {
                    HandlerMetaDataJAXWS hmd = HandlerMetaDataJAXWS.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                    this.serviceMetaData.addHandler(hmd);
                }
            }
            ((HandlerResolverImpl)this.handlerResolver).initServiceHandlerChain(this.serviceMetaData);
        }
    }

    private <T> QName getPortTypeName(Class<T> seiClass) {
        String nsURI;
        if (!seiClass.isAnnotationPresent(WebService.class)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_WEBSERVICE", (Object[])new Object[]{seiClass.getName()}));
        }
        WebService anWebService = seiClass.getAnnotation(WebService.class);
        String localPart = anWebService.name();
        if (localPart.length() == 0) {
            localPart = WSDLUtils.getJustClassName(seiClass);
        }
        if ((nsURI = anWebService.targetNamespace()).length() == 0) {
            nsURI = WSDLUtils.getTypeNamespace(seiClass);
        }
        QName portType = new QName(nsURI, localPart);
        return portType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getPortInternal(EndpointMetaData epMetaData, Class<T> seiClass) {
        QName portName = epMetaData.getPortName();
        if (!this.annotatedPorts.contains(portName)) {
            EndpointMetaData endpointMetaData = epMetaData;
            synchronized (endpointMetaData) {
                if (!this.annotatedPorts.contains(portName)) {
                    JAXWSClientMetaDataBuilder metaDataBuilder = new JAXWSClientMetaDataBuilder();
                    metaDataBuilder.rebuildEndpointMetaData(epMetaData, seiClass);
                    this.annotatedPorts.add(portName);
                }
            }
        }
        T port = this.createProxy(seiClass, epMetaData);
        NativeEndpointReference epr = epMetaData.getEndpointReference();
        if (epr != null) {
            this.initAddressingProperties((BindingProvider)port, epr);
        }
        this.initWebserviceFeatures(port, epMetaData.getFeatures().getFeatures());
        this.initWebserviceFeatures(port, this.features);
        return port;
    }

    private void assertSEIConstraints(Class seiClass) {
        if (seiClass == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SEI_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        if (!seiClass.isAnnotationPresent(WebService.class)) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MISSING_WEBSERVICE_ANNO", (Object[])new Object[]{seiClass}));
        }
    }

    public void addPort(QName portName, String bindingId, String epAddress) {
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            epMetaData = new ClientEndpointMetaData(this.serviceMetaData, portName, null, EndpointMetaData.Type.JAXWS);
            this.serviceMetaData.addEndpoint(epMetaData);
        }
        epMetaData.setBindingId(bindingId);
        epMetaData.setEndpointAddress(epAddress);
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode) {
        ExecutorService executor = (ExecutorService)this.getExecutor();
        EndpointMetaData epMetaData = this.getEndpointMetaData(portName);
        FeatureAwareClientEndpointMetaDataAdapter clientMetaDataAdapter = new FeatureAwareClientEndpointMetaDataAdapter((ClientEndpointMetaData)epMetaData);
        return new DispatchImpl<T>(executor, (EndpointMetaData)clientMetaDataAdapter, type, mode);
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext jbc, Service.Mode mode) {
        ExecutorService executor = (ExecutorService)this.getExecutor();
        EndpointMetaData epMetaData = this.getEndpointMetaData(portName);
        FeatureAwareClientEndpointMetaDataAdapter clientMetaDataAdapter = new FeatureAwareClientEndpointMetaDataAdapter((ClientEndpointMetaData)epMetaData);
        return new DispatchImpl<Object>(executor, (EndpointMetaData)clientMetaDataAdapter, jbc, mode);
    }

    private EndpointMetaData getEndpointMetaData(QName portName) {
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_PORT", (Object[])new Object[]{portName}));
        }
        return epMetaData;
    }

    public QName getServiceName() {
        return this.serviceMetaData.getServiceName();
    }

    public Iterator<QName> getPorts() {
        ArrayList<QName> portNames = new ArrayList<QName>();
        for (EndpointMetaData epMetaData : this.serviceMetaData.getEndpoints()) {
            portNames.add(epMetaData.getPortName());
        }
        return portNames.iterator();
    }

    public URL getWSDLDocumentLocation() {
        return this.serviceMetaData.getWsdlLocation();
    }

    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    public void setHandlerResolver(HandlerResolver handlerResolver) {
        this.handlerResolver = handlerResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getDefaultExecutor() {
        if (defaultExecutor == null) {
            Object object = DEFAULT_EXECUTOR_LOCK;
            synchronized (object) {
                if (defaultExecutor == null) {
                    defaultExecutor = Executors.newCachedThreadPool();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Created new defaultExecutor", new Throwable("Call Trace"));
                    }
                }
            }
        }
        return defaultExecutor;
    }

    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.getDefaultExecutor();
        }
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        if (!(executor instanceof ExecutorService)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"EXECUTORS_MUST_IMPLEMENT", (Object[])new Object[]{ExecutorService.class.getName()}));
        }
        this.executor = (ExecutorService)executor;
    }

    private <T> T createProxy(Class<T> seiClass, EndpointMetaData epMetaData) throws WebServiceException {
        if (seiClass == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SEI_CLASS_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        try {
            Object proxy;
            ExecutorService executor = (ExecutorService)this.getExecutor();
            FeatureAwareClientEndpointMetaDataAdapter clientMetaDataAdapter = new FeatureAwareClientEndpointMetaDataAdapter((ClientEndpointMetaData)epMetaData);
            ClientProxy handler = new ClientProxy(executor, new ClientImpl(clientMetaDataAdapter, this.handlerResolver));
            ClassLoader cl = epMetaData.getClassLoader();
            try {
                cl.loadClass(ProviderImpl.class.getName());
            }
            catch (Exception e) {
                ClassLoader clientCl = ProviderImpl.class.getClassLoader();
                cl = new DelegateClassLoader(clientCl, cl);
            }
            try {
                proxy = Proxy.newProxyInstance(cl, new Class[]{seiClass, BindingProvider.class, StubExt.class, FeatureAwareEndpointMetaData.class}, (InvocationHandler)handler);
            }
            catch (RuntimeException rte) {
                URL codeLocation = seiClass.getProtectionDomain().getCodeSource().getLocation();
                log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_CREATE_PROXY_FOR_SEI", (Object[])new Object[]{seiClass.getName(), codeLocation}));
                throw rte;
            }
            this.configureStub((StubExt)proxy);
            return (T)proxy;
        }
        catch (WebServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_CREATE_PROXY", (Object[])new Object[0]), (Throwable)ex);
        }
    }

    private void configureStub(StubExt stub) {
        EndpointMetaData epMetaData = stub.getEndpointMetaData();
        String seiName = epMetaData.getServiceEndpointInterfaceName();
        QName portName = epMetaData.getPortName();
        if (this.usRef == null) {
            log.debugf("No port configuration for: %s", (Object)portName);
            return;
        }
        String configFile = this.usRef.getConfigFile();
        String configName = this.usRef.getConfigName();
        UnifiedPortComponentRefMetaData pcref = this.usRef.getPortComponentRef(seiName, portName);
        if (pcref != null) {
            if (pcref.getConfigFile() != null) {
                configFile = pcref.getConfigFile();
            }
            if (pcref.getConfigName() != null) {
                configName = pcref.getConfigName();
            }
            BindingProvider bp = (BindingProvider)stub;
            Map reqCtx = bp.getRequestContext();
            for (UnifiedStubPropertyMetaData prop : pcref.getStubProperties()) {
                log.debugf("Set stub property: %s", (Object)prop);
                reqCtx.put(prop.getPropName(), prop.getPropValue());
            }
        }
        if (configName != null || configFile != null) {
            log.debugf("Configure Stub: [configName=%s,configFile=%s]", (Object)configName, (Object)configFile);
            stub.setConfigName(configName, configFile);
        }
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        Dispatch<T> dispatch = this.createDispatch(portName, type, mode);
        this.initWebserviceFeatures(dispatch, this.features);
        this.initWebserviceFeatures(dispatch, features);
        return dispatch;
    }

    public <T> Dispatch<T> createDispatch(EndpointReference epr, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        QName portName = null;
        NativeEndpointReference nepr = EndpointReferenceUtil.transform(NativeEndpointReference.class, epr);
        portName = nepr.getEndpointName();
        if (this.getEndpointMetaData(portName) != null && nepr.getAddress() != null && nepr.getAddress().length() > 0) {
            this.getEndpointMetaData(portName).setEndpointAddress(nepr.getAddress());
        }
        Dispatch<T> dispatch = this.createDispatch(portName, type, mode);
        this.initAddressingProperties((BindingProvider)dispatch, epr);
        this.initWebserviceFeatures(dispatch, this.features);
        this.initWebserviceFeatures(dispatch, features);
        return dispatch;
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        Dispatch<Object> dispatch = this.createDispatch(portName, context, mode);
        this.initWebserviceFeatures(dispatch, this.features);
        this.initWebserviceFeatures(dispatch, features);
        return dispatch;
    }

    public Dispatch<Object> createDispatch(EndpointReference epr, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        QName portName = null;
        NativeEndpointReference nepr = EndpointReferenceUtil.transform(NativeEndpointReference.class, epr);
        portName = nepr.getEndpointName();
        Dispatch<Object> dispatch = this.createDispatch(portName, context, mode);
        this.initAddressingProperties((BindingProvider)dispatch, epr);
        this.initWebserviceFeatures(dispatch, this.features);
        this.initWebserviceFeatures(dispatch, features);
        return dispatch;
    }

    public <T> T getPort(QName portName, Class<T> sei, WebServiceFeature ... features) {
        T port = this.getPort(portName, sei);
        this.initWebserviceFeatures(port, this.features);
        this.initWebserviceFeatures(port, features);
        return port;
    }

    public <T> T getPort(EndpointReference epr, Class<T> sei, WebServiceFeature ... features) {
        T port = this.getPort(sei);
        this.initAddressingProperties((BindingProvider)port, epr);
        this.initWebserviceFeatures(port, features);
        return port;
    }

    public <T> T getPort(Class<T> sei, WebServiceFeature ... features) {
        T port = this.getPort(sei);
        this.initWebserviceFeatures(port, features);
        return port;
    }

    public <T> T getPort(QName portName, Class<T> seiClass) {
        this.assertSEIConstraints(seiClass);
        if (this.serviceMetaData == null) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SERVICE_META_DATA_NOT_AVAILABLE", (Object[])new Object[0]));
        }
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null && this.serviceMetaData.getEndpoints().size() > 0) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GET_PORT_META_DATA", (Object[])new Object[]{portName}));
        }
        if (this.serviceMetaData.getEndpoints().size() == 0) {
            log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GET_PORT_META_DATA", (Object[])new Object[]{portName}));
            QName portType = this.getPortTypeName(seiClass);
            epMetaData = new ClientEndpointMetaData(this.serviceMetaData, portName, portType, EndpointMetaData.Type.JAXWS);
        }
        String seiClassName = seiClass.getName();
        epMetaData.setServiceEndpointInterfaceName(seiClassName);
        return this.getPortInternal(epMetaData, seiClass);
    }

    public <T> T getPort(Class<T> seiClass) {
        this.assertSEIConstraints(seiClass);
        if (this.serviceMetaData == null) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SERVICE_META_DATA_NOT_AVAILABLE", (Object[])new Object[0]));
        }
        String seiClassName = seiClass.getName();
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpointByServiceEndpointInterface(seiClassName);
        if (epMetaData == null && this.serviceMetaData.getEndpoints().size() == 1) {
            epMetaData = this.serviceMetaData.getEndpoints().get(0);
            epMetaData.setServiceEndpointInterfaceName(seiClassName);
        } else {
            QName portTypeName = this.getPortTypeName(seiClass);
            for (EndpointMetaData epmd : this.serviceMetaData.getEndpoints()) {
                if (!portTypeName.equals(epmd.getPortTypeName())) continue;
                epmd.setServiceEndpointInterfaceName(seiClass.getName());
                epMetaData = epmd;
                break;
            }
        }
        if (epMetaData == null) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GET_PORT_META_DATA", (Object[])new Object[]{seiClassName}));
        }
        return this.getPortInternal(epMetaData, seiClass);
    }

    private <T> void initWebserviceFeatures(T stub, WebServiceFeature ... features) {
        if (features != null) {
            EndpointMetaData epMetaData = ((EndpointMetadataProvider)stub).getEndpointMetaData();
            for (WebServiceFeature feature : features) {
                ClientFeatureProcessor.processFeature(feature, epMetaData, stub);
            }
        }
    }

    private void initAddressingProperties(BindingProvider bindingProvider, EndpointReference epr) {
        Map reqContext = bindingProvider.getRequestContext();
        AddressingBuilder builder = AddressingBuilder.getAddressingBuilder();
        AddressingProperties addrProps = builder.newAddressingProperties();
        reqContext.put("javax.xml.ws.addressing.context.outbound", addrProps);
        NativeEndpointReference nepr = EndpointReferenceUtil.transform(NativeEndpointReference.class, epr);
        try {
            List<Element> w3cRefParams;
            if (nepr.getAddress() != null) {
                addrProps.setTo(builder.newURI(nepr.getAddress()));
            }
            if ((w3cRefParams = nepr.getReferenceParameters()) != null) {
                ReferenceParameters refParams = addrProps.getReferenceParameters();
                for (Element w3cRefParam : w3cRefParams) {
                    refParams.addElement(w3cRefParam);
                }
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

