/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.jaxws;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AttributedURI;
import javax.xml.ws.addressing.EndpointReference;
import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.AddressingFeature;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.api.addressing.AddressingConstants;
import org.jboss.ws.api.handler.GenericSOAPHandler;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.utils.UUIDGenerator;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.DetailedAddressingException;
import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSAddressingServerHandler
extends GenericSOAPHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSAddressingServerHandler.class);
    private static Logger log = Logger.getLogger(WSAddressingServerHandler.class);
    private static AddressingBuilder ADDR_BUILDER;
    private static AddressingConstantsImpl ADDR_CONSTANTS;
    private static Set<QName> HEADERS;

    public Set getHeaders() {
        return Collections.unmodifiableSet(HEADERS);
    }

    protected boolean handleInbound(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleInbound");
        }
        SOAPAddressingProperties addrProps = (SOAPAddressingProperties)ADDR_BUILDER.newAddressingProperties();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        CommonMessageContext commonMsgContext = (CommonMessageContext)msgContext;
        if (this.isAddressingRequired(msgContext)) {
            try {
                soapMessage.setProperty("isRequired", (Object)true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        addrProps.readHeaders(soapMessage);
        if (addrProps.getAction() != null) {
            String wsaAction;
            String soapAction;
            msgContext.put((Object)"javax.xml.ws.addressing.context.inbound", (Object)addrProps);
            msgContext.setScope("javax.xml.ws.addressing.context.inbound", MessageContext.Scope.APPLICATION);
            msgContext.put((Object)"javax.xml.ws.reference.parameters", WSAddressingServerHandler.convertToElementList(addrProps.getReferenceParameters().getElements()));
            msgContext.setScope("javax.xml.ws.reference.parameters", MessageContext.Scope.APPLICATION);
            String[] soapActions = commonMsgContext.getMessageAbstraction().getMimeHeaders().getHeader("SOAPAction");
            if (!(soapActions == null || soapActions.length <= 0 || (soapAction = soapActions[0]).equals("\"\"") || addrProps.getAction() == null || soapAction.equals(wsaAction = addrProps.getAction().getURI().toString()) || soapAction.equals("\"" + wsaAction + "\""))) {
                QName code = new QName(ADDR_CONSTANTS.getNamespaceURI(), "ActionMismatch");
                String reason = "Mismatch between soap action:" + soapAction + " and wsa action:\"" + addrProps.getAction().getURI() + "\"";
                Element detail = DOMUtils.createElement((QName)new QName(ADDR_CONSTANTS.getNamespaceURI(), "ProblemAction"));
                throw new DetailedAddressingException(code, reason, detail);
            }
        }
        this.ensureAnonymousPolicy(addrProps, msgContext);
        return true;
    }

    private static List<Element> convertToElementList(List<Object> objects) {
        if (objects == null) {
            return null;
        }
        LinkedList<Element> elements = new LinkedList<Element>();
        for (Object o : objects) {
            if (!(o instanceof Element)) continue;
            elements.add((Element)o);
        }
        return elements;
    }

    protected boolean handleOutbound(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleOutbound");
        }
        if (this.isAddressingRequest(msgContext)) {
            this.handleResponseOrFault(msgContext, false);
        }
        return true;
    }

    public boolean handleFault(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleFault");
        }
        if (this.isAddressingRequest(msgContext)) {
            this.handleResponseOrFault(msgContext, true);
        }
        return true;
    }

    private void handleResponseOrFault(MessageContext msgContext, boolean isFault) {
        SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        SOAPAddressingProperties inProps = (SOAPAddressingProperties)msgContext.get((Object)"javax.xml.ws.addressing.context.inbound");
        SOAPAddressingProperties outProps = (SOAPAddressingProperties)msgContext.get((Object)"javax.xml.ws.addressing.context.outbound");
        if (outProps == null) {
            outProps = (SOAPAddressingProperties)builder.newAddressingProperties();
            msgContext.put((Object)"javax.xml.ws.addressing.context.outbound", (Object)outProps);
            msgContext.setScope("javax.xml.ws.addressing.context.outbound", MessageContext.Scope.APPLICATION);
        }
        if (inProps != null) {
            outProps.initializeAsReply(inProps, isFault);
        }
        OperationMetaData operationMD = this.getOperationMetaData(msgContext);
        AddressingOpMetaExt addressingMD = this.getAddressingMetaData(msgContext);
        if (!isFault && !operationMD.isOneWay()) {
            outProps.setAction(this.newURI(addressingMD.getOutboundAction()));
        } else if (isFault) {
            String faultAction = this.getFaultAction(msgContext);
            outProps.setAction(this.newURI(faultAction));
        }
        if (outProps.getMessageID() == null) {
            try {
                outProps.setMessageID(ADDR_BUILDER.newURI("urn:uuid:" + UUIDGenerator.generateRandomUUIDString()));
            }
            catch (URISyntaxException e) {
                log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_SETTING_RESPONSE_MESSAGEID", (Object[])new Object[0]), (Throwable)e);
            }
        }
        outProps.writeHeaders(soapMessage);
    }

    private AttributedURI newURI(String uri) {
        try {
            return ADDR_BUILDER.newURI(uri);
        }
        catch (URISyntaxException e) {
            throw new WebServiceException(e.getMessage(), (Throwable)e);
        }
    }

    private OperationMetaData getOperationMetaData(MessageContext msgContext) {
        CommonMessageContext commonCtx = (CommonMessageContext)msgContext;
        return commonCtx.getOperationMetaData();
    }

    private AddressingOpMetaExt getAddressingMetaData(MessageContext msgContext) {
        OperationMetaData operationMD = this.getOperationMetaData(msgContext);
        AddressingOpMetaExt addressingMD = null;
        if (operationMD != null && (addressingMD = (AddressingOpMetaExt)operationMD.getExtension(ADDR_CONSTANTS.getNamespaceURI())) == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ADDRESSING_META_DATA_NOT_AVAILABLE", (Object[])new Object[0]));
        }
        return addressingMD;
    }

    private void ensureAnonymousPolicy(SOAPAddressingProperties inProps, MessageContext msgContext) {
        CommonMessageContext commonCtx = (CommonMessageContext)msgContext;
        AddressingFeature addressing = commonCtx.getEndpointMetaData().getFeature(AddressingFeature.class);
        boolean isOnlyAnonymousEnabled = addressing != null && addressing.getResponses() == AddressingFeature.Responses.ANONYMOUS;
        boolean isOnlyNonAnonymousEnabled = addressing != null && addressing.getResponses() == AddressingFeature.Responses.NON_ANONYMOUS;
        boolean isReplyToAnonymous = this.isAnonymous(inProps.getReplyTo());
        boolean isFaultToAnonymous = this.isAnonymous(inProps.getFaultTo());
        if (!(!isOnlyAnonymousEnabled || isReplyToAnonymous && isFaultToAnonymous)) {
            try {
                QName faultCode = new QName(ADDR_CONSTANTS.getNamespaceURI(), "OnlyAnonymousAddressSupported");
                String reason = "A header representing a Message Addressing Property is not valid and the message cannot be processed";
                Node detail = this.getProblemHeaderDetail(!isReplyToAnonymous ? AddressingConstants.Core.Elements.REPLYTO_QNAME : AddressingConstants.Core.Elements.FAULTTO_QNAME);
                throw new DetailedAddressingException(faultCode, "A header representing a Message Addressing Property is not valid and the message cannot be processed", detail);
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
        if (isOnlyNonAnonymousEnabled && (isReplyToAnonymous || isFaultToAnonymous)) {
            try {
                QName faultCode = new QName(ADDR_CONSTANTS.getNamespaceURI(), "OnlyNonAnonymousAddressSupported");
                String reason = "A header representing a Message Addressing Property is not valid and the message cannot be processed";
                Node detail = this.getProblemHeaderDetail(isReplyToAnonymous ? AddressingConstants.Core.Elements.REPLYTO_QNAME : AddressingConstants.Core.Elements.FAULTTO_QNAME);
                throw new DetailedAddressingException(faultCode, "A header representing a Message Addressing Property is not valid and the message cannot be processed", detail);
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
    }

    private Node getProblemHeaderDetail(QName problemHeaderQName) throws SOAPException {
        Element problemHeaderQNameElement = DOMUtils.createElement((QName)AddressingConstants.Core.Elements.PROBLEMHEADERQNAME_QNAME);
        problemHeaderQNameElement.setTextContent(problemHeaderQName.toString());
        return problemHeaderQNameElement;
    }

    private boolean isAnonymous(EndpointReference epr) {
        if (epr != null && epr.getAddress() != null) {
            return ADDR_CONSTANTS.getAnonymousURI().equals(epr.getAddress().getURI().toString());
        }
        return true;
    }

    private String getFaultAction(MessageContext msgContext) {
        FaultMetaData faultMD;
        AddressingOpMetaExt addressingMD = this.getAddressingMetaData(msgContext);
        Throwable exception = ((CommonMessageContext)msgContext).getCurrentException();
        OperationMetaData operationMD = this.getOperationMetaData(msgContext);
        FaultMetaData faultMetaData = faultMD = operationMD != null ? operationMD.getFaultMetaData(exception.getClass()) : null;
        if (faultMD != null) {
            QName faultQName = faultMD.getXmlName();
            return addressingMD.getFaultAction(faultQName);
        }
        return ADDR_CONSTANTS.getDefaultFaultAction();
    }

    private boolean isAddressingRequired(MessageContext msgContext) {
        AddressingFeature addrFeature = this.getAddressingFeature(msgContext);
        return addrFeature != null && addrFeature.isEnabled() && addrFeature.isRequired();
    }

    private AddressingFeature getAddressingFeature(MessageContext msgContext) {
        CommonMessageContext commonMsgContext = (CommonMessageContext)msgContext;
        ServerEndpointMetaData serverMetaData = (ServerEndpointMetaData)commonMsgContext.getEndpointMetaData();
        return serverMetaData.getFeature(AddressingFeature.class);
    }

    private boolean isAddressingRequest(MessageContext msgContext) {
        return msgContext.get((Object)"javax.xml.ws.addressing.context.inbound") != null;
    }

    static {
        HEADERS = new HashSet<QName>();
        ADDR_CONSTANTS = new AddressingConstantsImpl();
        ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
        HEADERS.add(ADDR_CONSTANTS.getActionQName());
        HEADERS.add(ADDR_CONSTANTS.getToQName());
    }
}

