/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.util.HashSet;
import java.util.Set;

public class JavaKeywords {
    private static final JavaKeywords keywords = new JavaKeywords();
    private final String[] keywordsArray = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "if", "goto", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    private final String[] restrictedLiteralsArray = new String[]{"true", "false", "null"};
    private final Set<String> restrictedKeywords;

    private JavaKeywords() {
        int keywordsSize = this.keywordsArray.length + this.restrictedLiteralsArray.length;
        keywordsSize = (int)((double)keywordsSize / 0.75) + 1;
        this.restrictedKeywords = new HashSet<String>(keywordsSize);
        this.addAll(this.restrictedKeywords, this.keywordsArray);
        this.addAll(this.restrictedKeywords, this.restrictedLiteralsArray);
    }

    private void addAll(Set<String> set, String[] data) {
        for (String current : data) {
            set.add(current);
        }
    }

    private boolean internalIsRestrictedKeyword(String name) {
        return this.restrictedKeywords.contains(name);
    }

    public static boolean isJavaKeyword(String name) {
        return keywords.internalIsRestrictedKeyword(name);
    }
}

