/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.DefaultOperationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.web.MimeMappingAdd;
import org.jboss.as.web.MimeMappingRemove;
import org.jboss.as.web.WebContainerAdd;
import org.jboss.as.web.WebExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class WebContainerDefinition
extends SimpleResourceDefinition {
    public static final WebContainerDefinition INSTANCE = new WebContainerDefinition();
    protected static final SimpleListAttributeDefinition WELCOME_FILES = SimpleListAttributeDefinition.Builder.of((String)"welcome-file", (SimpleAttributeDefinition)new SimpleAttributeDefinitionBuilder("welcome-file", ModelType.STRING, true).setXmlName("welcome-file").setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1, true)).build()).setAllowNull(true).build();
    protected static final PropertiesAttributeDefinition MIME_MAPPINGS = new PropertiesAttributeDefinition("mime-mapping", "mime-mapping", true);
    private static final SimpleAttributeDefinition MIME_NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1, true)).build();
    private static final SimpleAttributeDefinition MIME_VALUE = new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1, true)).build();
    protected static final AttributeDefinition[] CONTAINER_ATTRIBUTES = new AttributeDefinition[]{WELCOME_FILES, MIME_MAPPINGS};

    private WebContainerDefinition() {
        super(WebExtension.CONTAINER_PATH, (ResourceDescriptionResolver)WebExtension.getResourceDescriptionResolver("container"), (OperationStepHandler)WebContainerAdd.INSTANCE, (OperationStepHandler)new ReloadRequiredRemoveStepHandler());
    }

    public void registerOperations(ManagementResourceRegistration container) {
        super.registerOperations(container);
        container.registerOperationHandler("add-mime", (OperationStepHandler)MimeMappingAdd.INSTANCE, (DescriptionProvider)new DefaultOperationDescriptionProvider("add-mime", (ResourceDescriptionResolver)WebExtension.getResourceDescriptionResolver("container.mime-mapping"), new AttributeDefinition[]{MIME_NAME, MIME_VALUE}));
        container.registerOperationHandler("remove-mime", (OperationStepHandler)MimeMappingRemove.INSTANCE, (DescriptionProvider)new DefaultOperationDescriptionProvider("remove-mime", (ResourceDescriptionResolver)WebExtension.getResourceDescriptionResolver("container.mime-mapping"), new AttributeDefinition[]{MIME_NAME}));
    }

    public void registerAttributes(ManagementResourceRegistration container) {
        container.registerReadWriteAttribute((AttributeDefinition)WELCOME_FILES, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{WELCOME_FILES}));
        container.registerReadWriteAttribute((AttributeDefinition)MIME_MAPPINGS, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{MIME_MAPPINGS}));
    }

    protected static class PropertiesAttributeDefinition
    extends MapAttributeDefinition {
        public PropertiesAttributeDefinition(String name, String xmlName, boolean allowNull) {
            super(name, xmlName, allowNull, 0, Integer.MAX_VALUE, (ParameterValidator)new ModelTypeValidator(ModelType.STRING), null, null, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
        }

        protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
            node.get("value-type").set(ModelType.STRING);
        }

        protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            node.get("value-type").set(ModelType.STRING);
        }

        protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            node.get("value-type").set(ModelType.STRING);
        }

        public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
            if (!this.isMarshallable(resourceModel)) {
                return;
            }
            resourceModel = resourceModel.get(this.getName());
            writer.writeStartElement(this.getName());
            for (ModelNode property : resourceModel.asList()) {
                writer.writeEmptyElement(this.getXmlName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.asProperty().getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), property.asProperty().getValue().asString());
            }
            writer.writeEndElement();
        }
    }
}

