/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebAccessLogDefinition;
import org.jboss.as.web.WebAccessLogDirectoryDefinition;
import org.jboss.as.web.WebConnectorDefinition;
import org.jboss.as.web.WebContainerDefinition;
import org.jboss.as.web.WebDefinition;
import org.jboss.as.web.WebDeploymentDefinition;
import org.jboss.as.web.WebDeploymentServletDefinition;
import org.jboss.as.web.WebJSPDefinition;
import org.jboss.as.web.WebReWriteConditionDefinition;
import org.jboss.as.web.WebReWriteDefinition;
import org.jboss.as.web.WebSSLDefinition;
import org.jboss.as.web.WebSSODefinition;
import org.jboss.as.web.WebStaticResources;
import org.jboss.as.web.WebSubsystemParser;
import org.jboss.as.web.WebVirtualHostDefinition;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class WebExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "web";
    protected static final PathElement CONNECTOR_PATH = PathElement.pathElement((String)"connector");
    protected static final PathElement SSL_PATH = PathElement.pathElement((String)"ssl", (String)"configuration");
    protected static final PathElement HOST_PATH = PathElement.pathElement((String)"virtual-server");
    protected static final PathElement JSP_CONFIGURATION_PATH = PathElement.pathElement((String)"configuration", (String)"jsp-configuration");
    protected static final PathElement STATIC_RESOURCES_PATH = PathElement.pathElement((String)"configuration", (String)"static-resources");
    protected static final PathElement CONTAINER_PATH = PathElement.pathElement((String)"configuration", (String)"container");
    protected static final PathElement ACCESS_LOG_PATH = PathElement.pathElement((String)"access-log", (String)"configuration");
    protected static final PathElement REWRITE_PATH = PathElement.pathElement((String)"rewrite");
    protected static final PathElement SSO_PATH = PathElement.pathElement((String)"sso", (String)"configuration");
    protected static final PathElement DIRECTORY_PATH = PathElement.pathElement((String)"directory", (String)"configuration");
    protected static final PathElement REWRITECOND_PATH = PathElement.pathElement((String)"condition");
    private static final String RESOURCE_NAME = WebExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 1;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        String prefix = SUBSYSTEM_NAME + (keyPrefix == null ? "" : "." + keyPrefix);
        return new StandardResourceDescriptionResolver(prefix, RESOURCE_NAME, WebExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 1);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)WebDefinition.INSTANCE);
        registration.registerOperationHandler("describe", (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)GenericSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)WebSubsystemParser.getInstance());
        ManagementResourceRegistration connectors = registration.registerSubModel((ResourceDefinition)WebConnectorDefinition.INSTANCE);
        ManagementResourceRegistration ssl = connectors.registerSubModel((ResourceDefinition)WebSSLDefinition.INSTANCE);
        ManagementResourceRegistration hosts = registration.registerSubModel((ResourceDefinition)WebVirtualHostDefinition.INSTANCE);
        ManagementResourceRegistration accesslog = hosts.registerSubModel((ResourceDefinition)WebAccessLogDefinition.INSTANCE);
        accesslog.registerSubModel((ResourceDefinition)WebAccessLogDirectoryDefinition.INSTANCE);
        hosts.registerSubModel((ResourceDefinition)WebSSODefinition.INSTANCE);
        ManagementResourceRegistration rewrite = hosts.registerSubModel((ResourceDefinition)WebReWriteDefinition.INSTANCE);
        rewrite.registerSubModel((ResourceDefinition)WebReWriteConditionDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebJSPDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebStaticResources.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebContainerDefinition.INSTANCE);
        ManagementResourceRegistration deployments = subsystem.registerDeploymentModel((ResourceDefinition)WebDeploymentDefinition.INSTANCE);
        deployments.registerSubModel((ResourceDefinition)WebDeploymentServletDefinition.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEB_1_1.getUriString(), (XMLElementReader)WebSubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEB_1_0.getUriString(), (XMLElementReader)WebSubsystemParser.getInstance());
    }
}

