/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.TypeAdaptor;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.util.ServiceTracker;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

abstract class AbstractInstallComplete
extends AbstractService<Void> {
    private Set<Bundle> installedBundles = new HashSet<Bundle>();
    private ServiceTracker<Bundle> tracker;

    AbstractInstallComplete() {
    }

    protected abstract ServiceName getServiceName();

    abstract boolean allServicesAdded(Set<ServiceName> var1);

    protected abstract void configureDependencies(ServiceBuilder<Void> var1);

    public ServiceListener<Bundle> getListener() {
        return this.tracker;
    }

    public ServiceBuilder<Void> install(ServiceTarget serviceTarget) {
        final AbstractInstallComplete installComplete = this;
        final ServiceBuilder builder = serviceTarget.addService(this.getServiceName(), (Service)this);
        this.tracker = new ServiceTracker<Bundle>(){

            @Override
            protected boolean allServicesAdded(Set<ServiceName> trackedServices) {
                return installComplete.allServicesAdded(trackedServices);
            }

            @Override
            protected void serviceStarted(ServiceController<? extends Bundle> controller) {
                Bundle bundle2 = (Bundle)controller.getValue();
                AbstractInstallComplete.this.installedBundles.add(bundle2);
            }

            @Override
            protected void complete() {
                builder.install();
            }
        };
        this.configureDependencies((ServiceBuilder<Void>)builder);
        return builder;
    }

    public void checkAndComplete() {
        this.tracker.checkAndComplete();
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        FrameworkLogger.LOGGER.tracef("Starting: %s", controller.getName());
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(this.installedBundles);
        Collections.sort(bundles, new BundleComparator());
        for (Bundle bundle2 : bundles) {
            TypeAdaptor adaptor = (TypeAdaptor)bundle2;
            Deployment dep = adaptor.adapt(Deployment.class);
            OSGiMetaData metadata = adaptor.adapt(OSGiMetaData.class);
            if (!dep.isAutoStart() || metadata.getFragmentHost() != null) continue;
            try {
                bundle2.start(2);
            }
            catch (BundleException ex) {
                FrameworkLogger.LOGGER.errorCannotStartBundle(ex, bundle2);
            }
        }
        FrameworkLogger.LOGGER.debugf("Started: %s", controller.getName());
        this.installedBundles = null;
        this.tracker = null;
    }

    static class BundleComparator
    implements Comparator<Bundle> {
        BundleComparator() {
        }

        @Override
        public int compare(Bundle b1, Bundle b2) {
            return (int)(b1.getBundleId() - b2.getBundleId());
        }
    }
}

