/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.osgi.framework.internal.AbstractBundleCapability;
import org.jboss.osgi.framework.internal.AbstractBundleRequirement;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.ResourceBuilderException;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilderFactory;
import org.jboss.osgi.resolver.spi.AbstractResource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;

abstract class AbstractBundleRevision
extends AbstractResource
implements BundleRevision {
    private final int revision;
    private final AbstractBundleState bundleState;
    private final OSGiMetaData metadata;
    private Map<String, List<BundleCapability>> bundleCapabilities;
    private Map<String, List<BundleRequirement>> bundleRequirements;

    AbstractBundleRevision(AbstractBundleState bundleState, OSGiMetaData metadata, int revision) throws BundleException {
        assert (bundleState != null) : "Null bundleState";
        assert (metadata != null) : "Null metadata";
        this.bundleState = bundleState;
        this.metadata = metadata;
        this.revision = revision;
        try {
            final AbstractBundleRevision brev = this;
            XResourceBuilderFactory factory = new XResourceBuilderFactory(){

                public AbstractResource createResource() {
                    return brev;
                }
            };
            XResourceBuilderFactory.create((XResourceBuilderFactory)factory).loadFrom(metadata);
        }
        catch (ResourceBuilderException ex) {
            throw new BundleException(ex.getMessage(), (Throwable)ex);
        }
    }

    static AbstractBundleRevision assertBundleRevision(Resource resource) {
        assert (resource instanceof AbstractBundleRevision) : "Not an AbstractBundleRevision: " + resource;
        return (AbstractBundleRevision)resource;
    }

    public String getSymbolicName() {
        return this.metadata.getBundleSymbolicName();
    }

    public Version getVersion() {
        return this.metadata.getBundleVersion();
    }

    String getCanonicalName() {
        return this.getSymbolicName() + ":" + this.getVersion();
    }

    public List<BundleCapability> getDeclaredCapabilities(String namespace) {
        if (this.bundleCapabilities == null) {
            HashMap<String, List<BundleCapability>> capmap = new HashMap<String, List<BundleCapability>>();
            ArrayList<AbstractBundleCapability> allcaps = new ArrayList<AbstractBundleCapability>();
            for (Capability cap : this.getCapabilities(null)) {
                String capns = cap.getNamespace();
                ArrayList<AbstractBundleCapability> caps = (ArrayList<AbstractBundleCapability>)capmap.get(capns);
                if (caps == null) {
                    caps = new ArrayList<AbstractBundleCapability>();
                    capmap.put(capns, caps);
                }
                AbstractBundleCapability bcap = new AbstractBundleCapability(this, capns, cap.getAttributes(), cap.getDirectives());
                allcaps.add(bcap);
                caps.add(bcap);
            }
            capmap.put(null, allcaps);
            this.bundleCapabilities = capmap;
        }
        List<BundleCapability> result = this.bundleCapabilities.get(namespace);
        return Collections.unmodifiableList(result);
    }

    public List<BundleRequirement> getDeclaredRequirements(String namespace) {
        if (this.bundleRequirements == null) {
            HashMap<String, List<BundleRequirement>> reqmap = new HashMap<String, List<BundleRequirement>>();
            ArrayList<AbstractBundleRequirement> allreqs = new ArrayList<AbstractBundleRequirement>();
            for (Requirement req : this.getRequirements(null)) {
                String reqns = req.getNamespace();
                ArrayList<AbstractBundleRequirement> reqs = (ArrayList<AbstractBundleRequirement>)reqmap.get(reqns);
                if (reqs == null) {
                    reqs = new ArrayList<AbstractBundleRequirement>();
                    reqmap.put(reqns, reqs);
                }
                AbstractBundleRequirement bcap = new AbstractBundleRequirement(this, reqns, req.getAttributes(), req.getDirectives());
                allreqs.add(bcap);
                reqs.add(bcap);
            }
            reqmap.put(null, allreqs);
            this.bundleRequirements = reqmap;
        }
        List<BundleRequirement> result = this.bundleRequirements.get(namespace);
        return Collections.unmodifiableList(result);
    }

    public int getTypes() {
        XIdentityCapability idcap = this.getIdentityCapability();
        boolean isfragment = "osgi.fragment".equals(idcap.getType());
        return isfragment ? 1 : 0;
    }

    public BundleWiring getWiring() {
        return (BundleWiring)this.getAttachment(Wiring.class);
    }

    public Bundle getBundle() {
        return this.bundleState;
    }

    int getRevisionId() {
        return this.revision;
    }

    AbstractBundleState getBundleState() {
        return this.bundleState;
    }

    OSGiMetaData getOSGiMetaData() {
        return this.metadata;
    }

    abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    abstract URL getResource(String var1);

    abstract Enumeration<URL> getResources(String var1) throws IOException;

    abstract Enumeration<String> getEntryPaths(String var1);

    abstract URL getEntry(String var1);

    abstract Enumeration<URL> findEntries(String var1, String var2, boolean var3);

    abstract String getLocation();

    abstract URL getLocalizationEntry(String var1);

    boolean isResolved() {
        return this.getWiring() != null;
    }

    ModuleIdentifier getModuleIdentifier() {
        return (ModuleIdentifier)this.getAttachment(ModuleIdentifier.class);
    }

    ModuleClassLoader getModuleClassLoader() throws ModuleLoadException {
        ModuleIdentifier identifier = this.getModuleIdentifier();
        ModuleManagerPlugin moduleManager = this.bundleState.getFrameworkState().getModuleManagerPlugin();
        Module module = moduleManager.loadModule(identifier);
        return module.getClassLoader();
    }

    void refreshRevision() throws BundleException {
        XEnvironment env = this.bundleState.getFrameworkState().getEnvironment();
        env.refreshResources(new XResource[]{this});
        this.refreshRevisionInternal();
    }

    void refreshRevisionInternal() {
        this.removeAttachment(Wiring.class);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.getCanonicalName() + "]";
    }
}

