/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.Closeable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.StorageState;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleId;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleInstalledService;
import org.jboss.osgi.framework.internal.FragmentBundleResolvedService;
import org.jboss.osgi.framework.internal.FrameworkBuilder;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleActiveService;
import org.jboss.osgi.framework.internal.HostBundleInstalledService;
import org.jboss.osgi.framework.internal.HostBundleResolvedService;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.SecurityActions;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.util.Java;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.VersionRange;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

final class BundleManagerPlugin
extends AbstractPluginService<BundleManager>
implements BundleManager {
    private static String OSGi_FRAMEWORK_EXECUTIONENVIRONMENT;
    private static String OSGi_FRAMEWORK_LANGUAGE;
    private static String OSGi_FRAMEWORK_OS_NAME;
    private static String OSGi_FRAMEWORK_OS_VERSION;
    private static String OSGi_FRAMEWORK_PROCESSOR;
    private static String OSGi_FRAMEWORK_VENDOR;
    private static String OSGi_FRAMEWORK_VERSION;
    private static String implementationVersion;
    private static final Set<String> IDENTITY_TYPES;
    final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();
    final InjectedValue<SystemBundleState> injectedSystemBundle = new InjectedValue();
    final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    final InjectedValue<Boolean> injectedFrameworkActive = new InjectedValue();
    private final FrameworkBuilder frameworkBuilder;
    private final AtomicLong identityGenerator = new AtomicLong();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final AtomicBoolean shutdownInitiated = new AtomicBoolean();
    private ServiceContainer serviceContainer;
    private ServiceTarget serviceTarget;

    static BundleManagerPlugin addService(ServiceTarget serviceTarget, FrameworkBuilder frameworkBuilder) {
        BundleManagerPlugin service = new BundleManagerPlugin(frameworkBuilder);
        ServiceBuilder builder = serviceTarget.addService(Services.BUNDLE_MANAGER, (Service)service);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, service.injectedEnvironment);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return service;
    }

    private BundleManagerPlugin(FrameworkBuilder frameworkBuilder) {
        this.frameworkBuilder = frameworkBuilder;
        this.properties.putAll(frameworkBuilder.getProperties());
        if (this.getProperty("org.osgi.framework.executionenvironment") == null) {
            this.setProperty("org.osgi.framework.executionenvironment", OSGi_FRAMEWORK_EXECUTIONENVIRONMENT);
        }
        if (this.getProperty("org.osgi.framework.language") == null) {
            this.setProperty("org.osgi.framework.language", OSGi_FRAMEWORK_LANGUAGE);
        }
        if (this.getProperty("org.osgi.framework.os.name") == null) {
            this.setProperty("org.osgi.framework.os.name", OSGi_FRAMEWORK_OS_NAME);
        }
        if (this.getProperty("org.osgi.framework.os.version") == null) {
            this.setProperty("org.osgi.framework.os.version", OSGi_FRAMEWORK_OS_VERSION);
        }
        if (this.getProperty("org.osgi.framework.processor") == null) {
            this.setProperty("org.osgi.framework.processor", OSGi_FRAMEWORK_PROCESSOR);
        }
        if (this.getProperty("org.osgi.framework.vendor") == null) {
            this.setProperty("org.osgi.framework.vendor", OSGi_FRAMEWORK_VENDOR);
        }
        if (this.getProperty("org.osgi.framework.version") == null) {
            this.setProperty("org.osgi.framework.version", OSGi_FRAMEWORK_VERSION);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BundleManagerPlugin.this.shutdownInitiated.set(true);
            }
        });
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        FrameworkLogger.LOGGER.infoFrameworkImplementation(implementationVersion);
        this.serviceContainer = context.getController().getServiceContainer();
        this.serviceTarget = context.getChildTarget();
        FrameworkLogger.LOGGER.debugf("Framework properties", new Object[0]);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            FrameworkLogger.LOGGER.debugf(" %s = %s", entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
    }

    public BundleManagerPlugin getValue() throws IllegalStateException {
        return this;
    }

    FrameworkBuilder getFrameworkBuilder() {
        return this.frameworkBuilder;
    }

    @Override
    public ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    @Override
    public SystemBundleState getSystemBundle() {
        return (SystemBundleState)this.injectedSystemBundle.getOptionalValue();
    }

    boolean isFrameworkCreated() {
        return !this.shutdownInitiated.get() && this.getFrameworkState() != null;
    }

    void assertFrameworkCreated() {
        if (!this.isFrameworkCreated()) {
            throw FrameworkMessages.MESSAGES.illegalStateFrameworkNotActive();
        }
    }

    @Override
    public boolean isFrameworkActive() {
        return Boolean.TRUE.equals(this.injectedFrameworkActive.getOptionalValue());
    }

    FrameworkState getFrameworkState() {
        return (FrameworkState)this.injectedFramework.getOptionalValue();
    }

    @Override
    public Object getProperty(String key) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = SecurityActions.getSystemProperty(key, null);
        }
        return value;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            m.put(entry.getKey().toString(), entry.getValue());
        }
        m.putAll(this.properties);
        return m;
    }

    void setProperty(String key, Object value) {
        if (this.isFrameworkCreated()) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotAddProperty();
        }
        this.properties.put(key, value);
    }

    static ServiceName getServiceName(Deployment dep) {
        long bundleId = ((BundleId)dep.getAttachment(BundleId.class)).longValue();
        return BundleManagerPlugin.getServiceNameInternal(bundleId, dep.getSymbolicName(), Version.parseVersion((String)dep.getVersion()));
    }

    private static ServiceName getServiceNameInternal(long bundleId, String symbolicName, Version version) {
        return ServiceName.of((ServiceName)Services.BUNDLE_BASE_NAME, (String[])new String[]{"" + bundleId, "" + symbolicName, "" + version});
    }

    Set<Bundle> getBundles() {
        HashSet<AbstractBundleState> result = new HashSet<AbstractBundleState>();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        for (XResource aux : env.getResources(IDENTITY_TYPES)) {
            AbstractBundleRevision brev;
            AbstractBundleState bundleState;
            if (!(aux instanceof AbstractBundleRevision) || (bundleState = (brev = (AbstractBundleRevision)aux).getBundleState()).getState() == 1) continue;
            result.add(bundleState);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<Bundle> getBundles(Integer states) {
        HashSet<AbstractBundleState> result = new HashSet<AbstractBundleState>();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        for (XResource aux : env.getResources(IDENTITY_TYPES)) {
            if (!(aux instanceof AbstractBundleRevision)) continue;
            AbstractBundleRevision brev = (AbstractBundleRevision)aux;
            AbstractBundleState bundleState = brev.getBundleState();
            if (states != null && (bundleState.getState() & states) == 0) continue;
            result.add(bundleState);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Bundle getBundleById(long bundleId) {
        if (bundleId == 0L) {
            return this.getFrameworkState().getSystemBundle();
        }
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        Collection resources = env.getResources(IDENTITY_TYPES);
        for (XResource aux : resources) {
            AbstractBundleRevision brev;
            AbstractBundleState bundleState;
            if (!(aux instanceof AbstractBundleRevision) || (bundleState = (brev = (AbstractBundleRevision)aux).getBundleState()).getBundleId() != bundleId) continue;
            return bundleState;
        }
        return null;
    }

    @Override
    public Bundle getBundleByLocation(String location) {
        assert (location != null) : "Null location";
        for (Bundle aux : this.getBundles()) {
            String auxLocation = aux.getLocation();
            if (!location.equals(auxLocation)) continue;
            return aux;
        }
        return null;
    }

    @Override
    public Set<Bundle> getBundles(String symbolicName, String versionRange) {
        HashSet<Bundle> resultSet = new HashSet<Bundle>();
        for (Bundle aux : this.getBundles(null)) {
            if (symbolicName != null && !symbolicName.equals(aux.getSymbolicName()) || versionRange != null && !VersionRange.parse((String)versionRange).isInRange(aux.getVersion())) continue;
            resultSet.add(aux);
        }
        return Collections.unmodifiableSet(resultSet);
    }

    @Override
    public ServiceName installBundle(Deployment deployment, ServiceListener<Bundle> listener) throws BundleException {
        ServiceName serviceName;
        if (deployment == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("deployment");
        }
        Bundle bundle2 = this.getBundleByLocation(deployment.getLocation());
        if (bundle2 != null) {
            FrameworkLogger.LOGGER.debugf("Installing an already existing bundle: %s", deployment);
            AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
            serviceName = bundleState.getServiceName(2);
            VFSUtils.safeClose((Closeable)deployment.getRoot());
        } else {
            try {
                StorageState storageState = (StorageState)deployment.getAttachment(StorageState.class);
                if (storageState != null) {
                    deployment.setAutoStart(storageState.isPersistentlyStarted());
                }
                BundleId bundleId = new BundleId(this.createBundleId(storageState));
                deployment.addAttachment(BundleId.class, (Object)bundleId);
                OSGiMetaData metadata = (OSGiMetaData)deployment.getAttachment(OSGiMetaData.class);
                if (metadata == null) {
                    DeploymentFactoryPlugin plugin = this.getFrameworkState().getDeploymentFactoryPlugin();
                    metadata = plugin.createOSGiMetaData(deployment);
                }
                if (metadata.getFragmentHost() == null) {
                    serviceName = HostBundleInstalledService.addService(this.serviceTarget, this.getFrameworkState(), deployment, listener);
                    HostBundleResolvedService.addService(this.serviceTarget, this.getFrameworkState(), serviceName.getParent());
                    HostBundleActiveService.addService(this.serviceTarget, this.getFrameworkState(), serviceName.getParent());
                } else {
                    serviceName = FragmentBundleInstalledService.addService(this.serviceTarget, this.getFrameworkState(), deployment);
                    FragmentBundleResolvedService.addService(this.serviceTarget, this.getFrameworkState(), serviceName.getParent());
                }
            }
            catch (RuntimeException rte) {
                VFSUtils.safeClose((Closeable)deployment.getRoot());
                throw rte;
            }
            catch (BundleException ex) {
                VFSUtils.safeClose((Closeable)deployment.getRoot());
                throw ex;
            }
        }
        deployment.addAttachment(ServiceName.class, (Object)serviceName);
        return serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long createBundleId(StorageState storageState) {
        AtomicLong atomicLong = this.identityGenerator;
        synchronized (atomicLong) {
            long result;
            if (storageState != null) {
                result = storageState.getBundleId();
                long diff = result - this.identityGenerator.get();
                if (diff > 0L) {
                    this.identityGenerator.addAndGet(diff);
                }
            } else {
                result = this.identityGenerator.incrementAndGet();
            }
            return result;
        }
    }

    @Override
    public void uninstallBundle(Deployment dep) {
        Bundle bundle2 = (Bundle)dep.getAttachment(Bundle.class);
        UserBundleState userBundle = UserBundleState.assertBundleState(bundle2);
        this.uninstallBundle(userBundle, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstallBundle(UserBundleState userBundle, int options) {
        if (userBundle.aquireUninstallLock()) {
            try {
                int state = userBundle.getState();
                if (state == 1) {
                    return;
                }
                if (!(userBundle.isFragment() || state != 32 && state != 8 && state != 16)) {
                    try {
                        userBundle.stopInternal(options);
                    }
                    catch (Exception ex) {
                        this.fireFrameworkError(userBundle, "stopping bundle: " + userBundle, ex);
                    }
                }
                FrameworkEventsPlugin eventsPlugin = userBundle.getFrameworkState().getFrameworkEventsPlugin();
                userBundle.changeState(1, 0);
                userBundle.removeServices();
                boolean hasActiveWires = userBundle.hasActiveWires();
                if (!hasActiveWires) {
                    this.removeBundle(userBundle, options);
                }
                eventsPlugin.fireBundleEvent(userBundle, 16);
                FrameworkLogger.LOGGER.infoBundleUninstalled(userBundle);
                Set<Bundle> uninstalled = this.getBundles(1);
                for (Bundle auxState : uninstalled) {
                    UserBundleState auxUser = UserBundleState.assertBundleState(auxState);
                    if (auxUser.hasActiveWires()) continue;
                    this.removeBundle(auxUser, options);
                }
            }
            finally {
                userBundle.releaseUninstallLock();
            }
        }
    }

    void removeBundle(UserBundleState userBundle, int options) {
        FrameworkLogger.LOGGER.tracef("Start removing bundle: %s", userBundle);
        if ((options & 1) == 0) {
            BundleStoragePlugin storagePlugin = this.getFrameworkState().getBundleStoragePlugin();
            storagePlugin.deleteStorageState(userBundle.getStorageState());
        }
        XEnvironment env = this.getFrameworkState().getEnvironment();
        for (AbstractBundleRevision abr : userBundle.getAllBundleRevisions()) {
            env.uninstallResources(new XResource[]{abr});
        }
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.fireBundleEvent(userBundle, 64);
        ModuleManagerPlugin moduleManager = this.getFrameworkState().getModuleManagerPlugin();
        for (AbstractBundleRevision rev : userBundle.getAllBundleRevisions()) {
            UserBundleRevision userRev = (UserBundleRevision)rev;
            if (!userBundle.isFragment()) {
                ModuleIdentifier identifier = moduleManager.getModuleIdentifier((XResource)rev);
                moduleManager.removeModule(identifier);
            }
            userRev.close();
        }
        FrameworkLogger.LOGGER.debugf("Removed bundle: %s", userBundle);
    }

    void setServiceMode(ServiceName serviceName, ServiceController.Mode mode) {
        ServiceController controller = this.serviceContainer.getService(serviceName);
        if (controller == null) {
            FrameworkLogger.LOGGER.debugf("Cannot set mode %s on non-existing service: %s", mode, serviceName);
        } else {
            this.setServiceMode(controller, mode);
        }
    }

    void setServiceMode(ServiceController<?> controller, ServiceController.Mode mode) {
        block2: {
            try {
                FrameworkLogger.LOGGER.tracef("Set mode %s on service: %s", mode, controller.getName());
                controller.setMode(mode);
            }
            catch (IllegalArgumentException rte) {
                if (rte.getMessage().equals("Container is shutting down")) break block2;
                throw rte;
            }
        }
    }

    void fireFrameworkError(AbstractBundleState bundleState, String context, Throwable t) {
        FrameworkEventsPlugin plugin = this.getFrameworkState().getFrameworkEventsPlugin();
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent(bundleState, 2, t);
        } else if (bundleState != null) {
            plugin.fireFrameworkEvent(bundleState, 2, new BundleException("Error " + context + " bundle: " + bundleState, t));
        } else {
            SystemBundleState systemBundle = (SystemBundleState)this.injectedSystemBundle.getValue();
            plugin.fireFrameworkEvent(systemBundle, 2, new BundleException("Error " + context, t));
        }
    }

    void fireFrameworkWarning(AbstractBundleState bundleState, String context, Throwable t) {
        FrameworkEventsPlugin plugin = this.getFrameworkState().getFrameworkEventsPlugin();
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent(bundleState, 16, t);
        } else if (bundleState != null) {
            plugin.fireFrameworkEvent(bundleState, 16, new BundleException("Error " + context + " bundle: " + bundleState, t));
        } else {
            SystemBundleState systemBundle = (SystemBundleState)this.injectedSystemBundle.getValue();
            plugin.fireFrameworkEvent(systemBundle, 16, new BundleException("Error " + context, t));
        }
    }

    static String getOSVersionInOSGiFormat() {
        int i;
        StringBuilder osgiVersion = new StringBuilder();
        String sysVersion = SecurityActions.getSystemProperty("os.version", null);
        String[] elements = sysVersion.split("\\.");
        for (i = 0; i < 3 && i < elements.length; ++i) {
            try {
                Integer.parseInt(elements[i]);
                if (i > 0) {
                    osgiVersion.append('.');
                }
                osgiVersion.append(elements[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                break;
            }
        }
        if (i == 3 && elements.length > 3) {
            osgiVersion.append('.');
            osgiVersion.append(elements[3]);
        }
        return osgiVersion.toString();
    }

    static {
        OSGi_FRAMEWORK_LANGUAGE = Locale.getDefault().getLanguage();
        OSGi_FRAMEWORK_VENDOR = "jboss.org";
        OSGi_FRAMEWORK_VERSION = "1.5";
        implementationVersion = BundleManagerPlugin.class.getPackage().getImplementationVersion();
        IDENTITY_TYPES = new HashSet<String>();
        IDENTITY_TYPES.add("osgi.bundle");
        IDENTITY_TYPES.add("osgi.fragment");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ArrayList<String> execEnvironments = new ArrayList<String>();
                if (Java.isCompatible(2)) {
                    execEnvironments.add("OSGi/Minimum-1.1");
                    execEnvironments.add("J2SE-1.1");
                }
                if (Java.isCompatible(3)) {
                    execEnvironments.add("OSGi/Minimum-1.2");
                    execEnvironments.add("J2SE-1.2");
                }
                if (Java.isCompatible(4)) {
                    execEnvironments.add("J2SE-1.3");
                }
                if (Java.isCompatible(5)) {
                    execEnvironments.add("J2SE-1.4");
                }
                if (Java.isCompatible(6)) {
                    execEnvironments.add("J2SE-1.5");
                }
                if (Java.isCompatible(7)) {
                    execEnvironments.add("JavaSE-1.6");
                }
                String envlist = ((Object)execEnvironments).toString();
                envlist = envlist.substring(1, envlist.length() - 1);
                OSGi_FRAMEWORK_EXECUTIONENVIRONMENT = envlist;
                OSGi_FRAMEWORK_OS_NAME = SecurityActions.getSystemProperty("os.name", null);
                OSGi_FRAMEWORK_OS_VERSION = BundleManagerPlugin.getOSVersionInOSGiFormat();
                OSGi_FRAMEWORK_PROCESSOR = SecurityActions.getSystemProperty("os.arch", null);
                SecurityActions.setSystemProperty("org.osgi.vendor.framework", "org.jboss.osgi.framework");
                return null;
            }
        });
    }
}

