/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleInstallHandler;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.osgi.framework.BundleException;

final class DefaultBundleInstallHandler
extends AbstractPluginService<BundleInstallHandler>
implements BundleInstallHandler {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();

    static void addIntegrationService(ServiceRegistry registry, ServiceTarget serviceTarget) {
        if (registry.getService(IntegrationServices.BUNDLE_INSTALL_HANDLER) == null) {
            DefaultBundleInstallHandler service = new DefaultBundleInstallHandler();
            ServiceBuilder builder = serviceTarget.addService(IntegrationServices.BUNDLE_INSTALL_HANDLER, (Service)service);
            builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, service.injectedBundleManager);
            builder.addDependency(Services.FRAMEWORK_CREATE);
            builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            builder.install();
        }
    }

    private DefaultBundleInstallHandler() {
    }

    public BundleInstallHandler getValue() {
        return this;
    }

    @Override
    public void installBundle(Deployment dep) throws BundleException {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        bundleManager.installBundle(dep, null);
    }

    @Override
    public void uninstallBundle(Deployment dep) {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        bundleManager.uninstallBundle(dep);
    }
}

