/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.ModuleLoaderProvider;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XResource;

final class DefaultModuleLoaderProvider
extends ModuleLoader
implements ModuleLoaderProvider {
    private Map<ModuleIdentifier, ModuleHolder> moduleSpecs = new ConcurrentHashMap<ModuleIdentifier, ModuleHolder>();

    static void addIntegrationService(ServiceRegistry registry, ServiceTarget serviceTarget) {
        if (registry.getService(IntegrationServices.MODULE_LOADER_PROVIDER) == null) {
            DefaultModuleLoaderProvider service = new DefaultModuleLoaderProvider();
            ServiceBuilder builder = serviceTarget.addService(IntegrationServices.MODULE_LOADER_PROVIDER, (Service)service);
            builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            builder.install();
        }
    }

    private DefaultModuleLoaderProvider() {
    }

    public void start(StartContext context) throws StartException {
        FrameworkLogger.LOGGER.tracef("Starting: %s", context.getController().getName());
    }

    public void stop(StopContext context) {
        FrameworkLogger.LOGGER.tracef("Stopping: %s", context.getController().getName());
    }

    public ModuleLoaderProvider getValue() {
        return this;
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return this;
    }

    public ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
        ModuleHolder moduleHolder = this.moduleSpecs.get(identifier);
        return moduleHolder != null ? moduleHolder.getModuleSpec() : null;
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Module module = null;
        ModuleHolder moduleHolder = this.moduleSpecs.get(identifier);
        if (moduleHolder != null && (module = moduleHolder.getModule()) == null) {
            module = this.loadModuleLocal(identifier);
            moduleHolder.setModule(module);
        }
        return module;
    }

    @Override
    public ModuleIdentifier getModuleIdentifier(XResource resource, int rev) {
        XIdentityCapability icap = resource.getIdentityCapability();
        String name = icap.getSymbolicName();
        String slot = icap.getVersion() + (rev > 0 ? "-rev" + rev : "");
        return ModuleIdentifier.create((String)("jbosgi." + name), (String)slot);
    }

    @Override
    public void addModule(ModuleSpec moduleSpec) {
        FrameworkLogger.LOGGER.tracef("addModule: %s", moduleSpec.getModuleIdentifier());
        ModuleIdentifier identifier = moduleSpec.getModuleIdentifier();
        if (this.moduleSpecs.get(identifier) != null) {
            throw FrameworkMessages.MESSAGES.illegalStateModuleAlreadyExists(identifier);
        }
        ModuleHolder moduleHolder = new ModuleHolder(moduleSpec);
        this.moduleSpecs.put(identifier, moduleHolder);
    }

    @Override
    public void addModule(Module module) {
        FrameworkLogger.LOGGER.tracef("addModule: %s", module.getIdentifier());
        ModuleIdentifier identifier = module.getIdentifier();
        if (this.moduleSpecs.get(identifier) != null) {
            throw FrameworkMessages.MESSAGES.illegalStateModuleAlreadyExists(identifier);
        }
        ModuleHolder moduleHolder = new ModuleHolder(module);
        this.moduleSpecs.put(identifier, moduleHolder);
    }

    @Override
    public void removeModule(ModuleIdentifier identifier) {
        FrameworkLogger.LOGGER.tracef("removeModule: %s", identifier);
        this.moduleSpecs.remove(identifier);
        try {
            Module module = this.loadModuleLocal(identifier);
            if (module != null) {
                this.unloadModuleLocal(module);
            }
        }
        catch (ModuleLoadException moduleLoadException) {
            // empty catch block
        }
    }

    public String toString() {
        return DefaultModuleLoaderProvider.class.getSimpleName();
    }

    static class ModuleHolder {
        private ModuleSpec moduleSpec;
        private Module module;

        ModuleHolder(ModuleSpec moduleSpec) {
            assert (moduleSpec != null) : "Null moduleSpec";
            this.moduleSpec = moduleSpec;
        }

        ModuleHolder(Module module) {
            assert (module != null) : "Null module";
            this.module = module;
        }

        ModuleSpec getModuleSpec() {
            return this.moduleSpec;
        }

        Module getModule() {
            return this.module;
        }

        void setModule(Module module) {
            this.module = module;
        }
    }
}

