/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractFrameworkService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.ServiceManagerPlugin;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.resolver.XEnvironment;

public final class FrameworkCreate
extends AbstractFrameworkService {
    private final FrameworkState frameworkState;

    static FrameworkState addService(ServiceTarget serviceTarget, BundleManagerPlugin bundleManager) {
        FrameworkState frameworkState = new FrameworkState(bundleManager);
        FrameworkCreate service = new FrameworkCreate(frameworkState);
        ServiceBuilder builder = serviceTarget.addService(Services.FRAMEWORK_CREATE, (Service)service);
        builder.addDependency(InternalServices.DEPLOYMENT_FACTORY_PLUGIN, DeploymentFactoryPlugin.class, frameworkState.injectedDeploymentFactory);
        builder.addDependency(InternalServices.BUNDLE_STORAGE_PLUGIN, BundleStoragePlugin.class, frameworkState.injectedBundleStorage);
        builder.addDependency(InternalServices.FRAMEWORK_EVENTS_PLUGIN, FrameworkEventsPlugin.class, frameworkState.injectedFrameworkEvents);
        builder.addDependency(InternalServices.MODULE_MANGER_PLUGIN, ModuleManagerPlugin.class, frameworkState.injectedModuleManager);
        builder.addDependency(InternalServices.NATIVE_CODE_PLUGIN, NativeCodePlugin.class, frameworkState.injectedNativeCode);
        builder.addDependency(InternalServices.SERVICE_MANAGER_PLUGIN, ServiceManagerPlugin.class, frameworkState.injectedServiceManager);
        builder.addDependency(Services.SYSTEM_BUNDLE, SystemBundleState.class, frameworkState.injectedSystemBundle);
        builder.addDependency(InternalServices.RESOLVER_PLUGIN, ResolverPlugin.class, frameworkState.injectedResolverPlugin);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, frameworkState.injectedEnvironment);
        builder.addDependency(Services.STORAGE_STATE_PROVIDER);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return frameworkState;
    }

    private FrameworkCreate(FrameworkState frameworkState) {
        this.frameworkState = frameworkState;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        this.getBundleManager().injectedFramework.inject((Object)this.frameworkState);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.getBundleManager().injectedFramework.uninject();
    }

    public FrameworkState getValue() {
        return this.frameworkState;
    }
}

