/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.versions.Shell;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxOptions;

public class FirefoxDriverManager
extends WebDriverManager {
    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.FIREFOX;
    }

    @Override
    protected String getDriverName() {
        return "geckodriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getGeckoDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return this.config().getFirefoxVersion();
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setGeckoDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
        this.config().setFirefoxVersion(browserVersion);
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getFirefoxDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getFirefoxDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getFirefoxDriverExport());
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setFirefoxDriverUrl(url);
    }

    @Override
    protected List<URL> getDriverUrls(String driverVersion) throws IOException {
        if (this.isUseMirror()) {
            Object versionPath = driverVersion;
            if (!driverVersion.isEmpty() && !driverVersion.equals("0.3.0")) {
                versionPath = "v" + (String)versionPath;
            }
            return this.getDriversFromMirror(this.getMirrorUrl().get(), (String)versionPath);
        }
        return this.getDriversFromGitHub(driverVersion);
    }

    @Override
    protected String getCurrentVersion(URL url) {
        int firstDash = url.getFile().indexOf("-");
        int nextDash = url.getFile().indexOf("-", firstDash + 1);
        String currentVersion = url.getFile().substring(firstDash + 1, nextDash);
        if (currentVersion.startsWith("v")) {
            currentVersion = currentVersion.substring(1);
        }
        return currentVersion;
    }

    @Override
    protected Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion) {
        return Optional.empty();
    }

    @Override
    protected Capabilities getCapabilities() {
        return new FirefoxOptions();
    }

    @Override
    protected List<File> postDownload(File archive) {
        List<File> fileList = super.postDownload(archive);
        if (this.config().getOperatingSystem().isMac()) {
            log.debug("Bypass notarization requirement for geckodriver on Mac OS");
            Shell.runAndWait("xattr", "-r", "-d", "com.apple.quarantine", fileList.iterator().next().toString());
        }
        return fileList;
    }

    @Override
    public WebDriverManager exportParameter(String exportParameter) {
        this.config().setFirefoxDriverExport(exportParameter);
        return this;
    }
}

