/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.bulkhead.configuration;

import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.common.CommonProperties;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.bulkhead.configuration.ThreadPoolBulkheadConfigCustomizer;
import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.ContextPropagator;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CommonThreadPoolBulkheadConfigurationProperties
extends CommonProperties {
    private static final String DEFAULT = "default";
    private Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getBackends() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    @Nullable
    public InstanceProperties getBackendProperties(String backend) {
        InstanceProperties instanceProperties = this.instances.get(backend);
        if (instanceProperties == null) {
            instanceProperties = this.configs.get(DEFAULT);
        } else if (this.configs.get(DEFAULT) != null) {
            ConfigUtils.mergePropertiesIfAny(this.configs.get(DEFAULT), instanceProperties);
        }
        return instanceProperties;
    }

    public ThreadPoolBulkheadConfig createThreadPoolBulkheadConfig(String backend, CompositeCustomizer<ThreadPoolBulkheadConfigCustomizer> compositeThreadPoolBulkheadCustomizer) {
        return this.createThreadPoolBulkheadConfig(this.getBackendProperties(backend), compositeThreadPoolBulkheadCustomizer, backend);
    }

    public ThreadPoolBulkheadConfig createThreadPoolBulkheadConfig(@Nullable InstanceProperties instanceProperties, CompositeCustomizer<ThreadPoolBulkheadConfigCustomizer> compositeThreadPoolBulkheadCustomizer, String instanceName) {
        ThreadPoolBulkheadConfig baseConfig = null;
        if (instanceProperties != null && StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            ConfigUtils.mergePropertiesIfAny(baseProperties, instanceProperties);
            baseConfig = this.createThreadPoolBulkheadConfig(baseProperties, compositeThreadPoolBulkheadCustomizer, instanceProperties.getBaseConfig());
        } else if (!instanceName.equals(DEFAULT) && this.configs.get(DEFAULT) != null) {
            if (instanceProperties != null) {
                ConfigUtils.mergePropertiesIfAny(this.configs.get(DEFAULT), instanceProperties);
            }
            baseConfig = this.createThreadPoolBulkheadConfig(this.configs.get(DEFAULT), compositeThreadPoolBulkheadCustomizer, DEFAULT);
        }
        return this.buildConfig(baseConfig != null ? ThreadPoolBulkheadConfig.from(baseConfig) : ThreadPoolBulkheadConfig.custom(), instanceProperties, compositeThreadPoolBulkheadCustomizer, instanceName);
    }

    private ThreadPoolBulkheadConfig buildConfig(ThreadPoolBulkheadConfig.Builder builder, InstanceProperties properties, CompositeCustomizer<ThreadPoolBulkheadConfigCustomizer> compositeThreadPoolBulkheadCustomizer, String instanceName) {
        if (properties != null) {
            if (properties.getQueueCapacity() >= 0) {
                builder.queueCapacity(properties.getQueueCapacity());
            }
            if (properties.getCoreThreadPoolSize() > 0) {
                builder.coreThreadPoolSize(properties.getCoreThreadPoolSize());
            }
            if (properties.getMaxThreadPoolSize() > 0) {
                builder.maxThreadPoolSize(properties.getMaxThreadPoolSize());
            }
            if (properties.getKeepAliveDuration() != null) {
                builder.keepAliveDuration(properties.getKeepAliveDuration());
            }
            if (properties.getWritableStackTraceEnabled() != null) {
                builder.writableStackTraceEnabled(properties.getWritableStackTraceEnabled().booleanValue());
            }
            if (properties.getContextPropagators() != null) {
                builder.contextPropagator((Class[])properties.getContextPropagators());
            }
        }
        compositeThreadPoolBulkheadCustomizer.getCustomizer(instanceName).ifPresent(threadPoolBulkheadConfigCustomizer -> threadPoolBulkheadConfigCustomizer.customize(builder));
        return builder.build();
    }

    public static class InstanceProperties {
        @Nullable
        private Integer eventConsumerBufferSize;
        @Nullable
        private String baseConfig;
        @Nullable
        private Boolean writableStackTraceEnabled;
        private int maxThreadPoolSize;
        private int coreThreadPoolSize;
        private int queueCapacity = -1;
        private Duration keepAliveDuration;
        @Nullable
        private Class<? extends ContextPropagator>[] contextPropagators;

        public int getMaxThreadPoolSize() {
            return this.maxThreadPoolSize;
        }

        public InstanceProperties setMaxThreadPoolSize(int maxThreadPoolSize) {
            this.maxThreadPoolSize = maxThreadPoolSize;
            return this;
        }

        public int getCoreThreadPoolSize() {
            return this.coreThreadPoolSize;
        }

        public InstanceProperties setCoreThreadPoolSize(int coreThreadPoolSize) {
            this.coreThreadPoolSize = coreThreadPoolSize;
            return this;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public InstanceProperties setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
            return this;
        }

        public Duration getKeepAliveDuration() {
            return this.keepAliveDuration;
        }

        public InstanceProperties setKeepAliveDuration(Duration keepAliveDuration) {
            this.keepAliveDuration = keepAliveDuration;
            return this;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            Objects.requireNonNull(eventConsumerBufferSize);
            if (eventConsumerBufferSize < 1) {
                throw new IllegalArgumentException("eventConsumerBufferSize must be greater than or equal to 1.");
            }
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        public Boolean getWritableStackTraceEnabled() {
            return this.writableStackTraceEnabled;
        }

        public InstanceProperties setWritableStackTraceEnabled(boolean writableStackTraceEnabled) {
            this.writableStackTraceEnabled = writableStackTraceEnabled;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }

        public Class<? extends ContextPropagator>[] getContextPropagators() {
            return this.contextPropagators;
        }

        public InstanceProperties setContextPropagators(Class<? extends ContextPropagator> ... contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }
    }
}

