/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.circuitbreaker.monitoring.endpoint;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerEventDTO;
import io.github.resilience4j.core.lang.Nullable;
import java.time.Duration;

class CircuitBreakerEventDTOBuilder {
    private final String circuitBreakerName;
    private final CircuitBreakerEvent.Type type;
    private final String creationTime;
    @Nullable
    private String throwable = null;
    @Nullable
    private Long duration = null;
    @Nullable
    private CircuitBreaker.StateTransition stateTransition = null;

    CircuitBreakerEventDTOBuilder(String circuitBreakerName, CircuitBreakerEvent.Type type, String creationTime) {
        this.circuitBreakerName = circuitBreakerName;
        this.type = type;
        this.creationTime = creationTime;
    }

    CircuitBreakerEventDTOBuilder setThrowable(Throwable throwable) {
        this.throwable = throwable.toString();
        return this;
    }

    CircuitBreakerEventDTOBuilder setDuration(Duration duration) {
        this.duration = duration.toMillis();
        return this;
    }

    CircuitBreakerEventDTOBuilder setStateTransition(CircuitBreaker.StateTransition stateTransition) {
        this.stateTransition = stateTransition;
        return this;
    }

    CircuitBreakerEventDTO build() {
        return new CircuitBreakerEventDTO(this.circuitBreakerName, this.type, this.creationTime, this.throwable, this.duration, this.stateTransition);
    }
}

