/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.ratelimiter.monitoring.endpoint;

import io.github.resilience4j.common.ratelimiter.monitoring.endpoint.RateLimiterEndpointResponse;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="ratelimiters")
public class RateLimiterEndpoint {
    private final RateLimiterRegistry rateLimiterRegistry;

    public RateLimiterEndpoint(RateLimiterRegistry rateLimiterRegistry) {
        this.rateLimiterRegistry = rateLimiterRegistry;
    }

    @ReadOperation
    public RateLimiterEndpointResponse getAllRateLimiters() {
        List names = this.rateLimiterRegistry.getAllRateLimiters().stream().map(RateLimiter::getName).sorted().collect(Collectors.toList());
        return new RateLimiterEndpointResponse(names);
    }
}

