/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.bulkhead.configure.threadpool;

import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.bulkhead.configuration.CommonThreadPoolBulkheadConfigurationProperties;
import io.github.resilience4j.common.bulkhead.configuration.ThreadPoolBulkheadConfigCustomizer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class ThreadPoolBulkheadConfiguration {
    @Bean
    @Qualifier(value="compositeThreadPoolBulkheadCustomizer")
    public CompositeCustomizer<ThreadPoolBulkheadConfigCustomizer> compositeThreadPoolBulkheadCustomizer(@Autowired(required=false) List<ThreadPoolBulkheadConfigCustomizer> customizers) {
        return new CompositeCustomizer(customizers);
    }

    @Bean
    public ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry(CommonThreadPoolBulkheadConfigurationProperties bulkheadConfigurationProperties, EventConsumerRegistry<BulkheadEvent> bulkheadEventConsumerRegistry, RegistryEventConsumer<ThreadPoolBulkhead> threadPoolBulkheadRegistryEventConsumer, @Qualifier(value="compositeThreadPoolBulkheadCustomizer") CompositeCustomizer<ThreadPoolBulkheadConfigCustomizer> compositeThreadPoolBulkheadCustomizer) {
        ThreadPoolBulkheadRegistry bulkheadRegistry = this.createBulkheadRegistry(bulkheadConfigurationProperties, threadPoolBulkheadRegistryEventConsumer, compositeThreadPoolBulkheadCustomizer);
        this.registerEventConsumer(bulkheadRegistry, bulkheadEventConsumerRegistry, bulkheadConfigurationProperties);
        bulkheadConfigurationProperties.getBackends().forEach((name, properties) -> bulkheadRegistry.bulkhead(name, bulkheadConfigurationProperties.createThreadPoolBulkheadConfig(name, compositeThreadPoolBulkheadCustomizer)));
        return bulkheadRegistry;
    }

    @Bean
    @Primary
    public RegistryEventConsumer<ThreadPoolBulkhead> threadPoolBulkheadRegistryEventConsumer(Optional<List<RegistryEventConsumer<ThreadPoolBulkhead>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    private ThreadPoolBulkheadRegistry createBulkheadRegistry(CommonThreadPoolBulkheadConfigurationProperties threadPoolBulkheadConfigurationProperties, RegistryEventConsumer<ThreadPoolBulkhead> threadPoolBulkheadRegistryEventConsumer, CompositeCustomizer<ThreadPoolBulkheadConfigCustomizer> compositeThreadPoolBulkheadCustomizer) {
        Map<String, ThreadPoolBulkheadConfig> configs = threadPoolBulkheadConfigurationProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> threadPoolBulkheadConfigurationProperties.createThreadPoolBulkheadConfig((CommonThreadPoolBulkheadConfigurationProperties.InstanceProperties)entry.getValue(), compositeThreadPoolBulkheadCustomizer, (String)entry.getKey())));
        return ThreadPoolBulkheadRegistry.of(configs, threadPoolBulkheadRegistryEventConsumer, Map.copyOf(threadPoolBulkheadConfigurationProperties.getTags()));
    }

    private void registerEventConsumer(ThreadPoolBulkheadRegistry bulkheadRegistry, EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry, CommonThreadPoolBulkheadConfigurationProperties properties) {
        bulkheadRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (ThreadPoolBulkhead)event.getAddedEntry(), properties)).onEntryReplaced(event -> this.registerEventConsumer(eventConsumerRegistry, (ThreadPoolBulkhead)event.getNewEntry(), properties));
    }

    private void registerEventConsumer(EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry, ThreadPoolBulkhead bulkHead, CommonThreadPoolBulkheadConfigurationProperties bulkheadConfigurationProperties) {
        int eventConsumerBufferSize = Optional.ofNullable(bulkheadConfigurationProperties.getBackendProperties(bulkHead.getName())).map(CommonThreadPoolBulkheadConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        bulkHead.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(String.join((CharSequence)"-", ThreadPoolBulkhead.class.getSimpleName(), bulkHead.getName()), eventConsumerBufferSize));
    }
}

