/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.retry.configure;

import io.github.resilience4j.reactor.retry.RetryOperator;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.spring6.retry.configure.RetryAspectExt;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorRetryAspectExt
implements RetryAspectExt {
    private static final Logger logger = LoggerFactory.getLogger(ReactorRetryAspectExt.class);

    @Override
    public boolean canHandleReturnType(Class returnType) {
        return Flux.class.isAssignableFrom(returnType) || Mono.class.isAssignableFrom(returnType);
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, Retry retry, String methodName) throws Throwable {
        Object returnValue = proceedingJoinPoint.proceed();
        if (Flux.class.isAssignableFrom(returnValue.getClass())) {
            Flux fluxReturnValue = (Flux)returnValue;
            return fluxReturnValue.transformDeferred((Function)RetryOperator.of((Retry)retry));
        }
        if (Mono.class.isAssignableFrom(returnValue.getClass())) {
            Mono monoReturnValue = (Mono)returnValue;
            return monoReturnValue.transformDeferred((Function)RetryOperator.of((Retry)retry));
        }
        logger.error("Unsupported type for Reactor retry {}", (Object)returnValue.getClass().getTypeName());
        throw new IllegalArgumentException("Not Supported type for the retry in Reactor :" + returnValue.getClass().getName());
    }
}

