/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.micrometer.configure;

import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.micrometer.transformer.TimerTransformer;
import io.github.resilience4j.spring6.micrometer.configure.TimerAspectExt;
import io.github.resilience4j.spring6.timelimiter.configure.IllegalReturnTypeException;
import io.github.resilience4j.spring6.utils.AspectUtil;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;

public class RxJava2TimerAspectExt
implements TimerAspectExt {
    private final Set<Class<?>> rxSupportedTypes = AspectUtil.newHashSet(ObservableSource.class, SingleSource.class, CompletableSource.class, MaybeSource.class, Flowable.class);

    @Override
    public boolean canHandleReturnType(Class<?> returnType) {
        return this.rxSupportedTypes.stream().anyMatch(classType -> classType.isAssignableFrom(returnType));
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, Timer timer, String methodName) throws Throwable {
        TimerTransformer timerTransformer = TimerTransformer.of((Timer)timer);
        Object returnValue = proceedingJoinPoint.proceed();
        return RxJava2TimerAspectExt.executeRxJava2Aspect(timerTransformer, returnValue, methodName);
    }

    private static Object executeRxJava2Aspect(TimerTransformer timerTransformer, Object returnValue, String methodName) {
        if (returnValue instanceof ObservableSource) {
            Observable observable = (Observable)returnValue;
            return observable.compose((ObservableTransformer)timerTransformer);
        }
        if (returnValue instanceof SingleSource) {
            Single single = (Single)returnValue;
            return single.compose((SingleTransformer)timerTransformer);
        }
        if (returnValue instanceof CompletableSource) {
            Completable completable = (Completable)returnValue;
            return completable.compose((CompletableTransformer)timerTransformer);
        }
        if (returnValue instanceof MaybeSource) {
            Maybe maybe = (Maybe)returnValue;
            return maybe.compose((MaybeTransformer)timerTransformer);
        }
        if (returnValue instanceof Flowable) {
            Flowable flowable = (Flowable)returnValue;
            return flowable.compose((FlowableTransformer)timerTransformer);
        }
        throw new IllegalReturnTypeException(returnValue.getClass(), methodName, "RxJava2 expects Flowable/Single/...");
    }
}

